/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.common.recipes.inventory.EmptyInventory;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class BlastFurnaceRecipe
implements ISimpleRecipe<Inventory> {
    private final ResourceLocation id;
    private final FluidStackIngredient inputFluid;
    private final Ingredient catalyst;
    private final FluidStack outputFluid;

    @Nullable
    public static BlastFurnaceRecipe get(Level level, ItemStack stack) {
        ItemStackInventory inventory = new ItemStackInventory(stack);
        HeatingRecipe heatRecipe = HeatingRecipe.getRecipe(inventory);
        if (heatRecipe != null) {
            FluidStack moltenFluid = heatRecipe.assembleFluid(inventory);
            for (BlastFurnaceRecipe recipe : Helpers.getRecipes(level, TFCRecipeTypes.BLAST_FURNACE).values()) {
                if (!recipe.inputFluid.ingredient().test(moltenFluid.getFluid())) continue;
                return recipe;
            }
        }
        return null;
    }

    @Nullable
    public static BlastFurnaceRecipe get(Level level, FluidStack inputFluid) {
        for (BlastFurnaceRecipe recipe : Helpers.getRecipes(level, TFCRecipeTypes.BLAST_FURNACE).values()) {
            if (!recipe.inputFluid.ingredient().test(inputFluid.getFluid())) continue;
            return recipe;
        }
        return null;
    }

    public BlastFurnaceRecipe(ResourceLocation id, FluidStackIngredient inputFluid, Ingredient catalyst, FluidStack outputFluid) {
        this.id = id;
        this.inputFluid = inputFluid;
        this.catalyst = catalyst;
        this.outputFluid = outputFluid;
    }

    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public FluidStackIngredient getInputFluid() {
        return this.inputFluid;
    }

    public boolean matches(Inventory inventory, @Nullable Level level) {
        return this.inputFluid.test(inventory.getFluid()) && this.catalyst.test(inventory.getCatalyst());
    }

    public boolean matchesInput(ItemStack stack) {
        ItemStackInventory inventory = new ItemStackInventory(stack);
        HeatingRecipe heat = HeatingRecipe.getRecipe(inventory);
        if (heat != null) {
            FluidStack fluid = heat.assembleFluid(inventory);
            return this.inputFluid.ingredient().test(fluid.getFluid());
        }
        return false;
    }

    public boolean matchesCatalyst(ItemStack stack) {
        return this.catalyst.test(stack);
    }

    public FluidStack assembleFluidOutput(FluidStack inputFluid) {
        int maximumRatio = inputFluid.getAmount() / this.inputFluid.amount();
        FluidStack outputFluid = this.outputFluid.copy();
        inputFluid.shrink(maximumRatio * this.inputFluid.amount());
        outputFluid.setAmount(this.outputFluid.getAmount() * maximumRatio);
        return outputFluid;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.BLAST_FURNACE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.BLAST_FURNACE.get();
    }

    public static interface Inventory
    extends EmptyInventory {
        public FluidStack getFluid();

        public ItemStack getCatalyst();
    }

    public static class Serializer
    extends RecipeSerializerImpl<BlastFurnaceRecipe> {
        public BlastFurnaceRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            FluidStackIngredient inputFluid = FluidStackIngredient.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"fluid"));
            Ingredient catalyst = Ingredient.m_43917_((JsonElement)JsonHelpers.m_13930_((JsonObject)json, (String)"catalyst"));
            FluidStack outputFluid = JsonHelpers.getFluidStack(json, "result");
            return new BlastFurnaceRecipe(recipeId, inputFluid, catalyst, outputFluid);
        }

        @Nullable
        public BlastFurnaceRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            FluidStackIngredient inputFluid = FluidStackIngredient.fromNetwork(buffer);
            Ingredient catalyst = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            FluidStack outputFluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            return new BlastFurnaceRecipe(recipeId, inputFluid, catalyst, outputFluid);
        }

        public void toNetwork(FriendlyByteBuf buffer, BlastFurnaceRecipe recipe) {
            recipe.inputFluid.toNetwork(buffer);
            recipe.catalyst.m_43923_(buffer);
            recipe.outputFluid.writeToPacket(buffer);
        }
    }
}

