/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import java.util.ArrayList;
import java.util.Random;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.TFCFallingBlockEntity;
import net.dries007.tfc.common.recipes.SimpleBlockRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.common.recipes.inventory.BlockInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Support;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.tracker.Collapse;
import net.dries007.tfc.util.tracker.WorldTrackerCapability;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CollapseRecipe
extends SimpleBlockRecipe {
    public static final IndirectHashCollection<Block, CollapseRecipe> CACHE = IndirectHashCollection.createForRecipe(recipe -> recipe.getBlockIngredient().getValidBlocks(), TFCRecipeTypes.COLLAPSE);

    @Nullable
    public static CollapseRecipe getRecipe(Level world, BlockInventory wrapper) {
        for (CollapseRecipe recipe : CACHE.getAll(wrapper.getState().m_60734_())) {
            if (!recipe.matches(wrapper, world)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean tryTriggerCollapse(Level level, BlockPos pos) {
        Random random = level.m_5822_();
        if (!level.m_5776_() && level.isAreaLoaded(pos, 32) && (double)random.nextFloat() < (Double)TFCConfig.SERVER.collapseTriggerChance.get()) {
            int radX = (random.nextInt(5) + 4) / 2;
            int radY = (random.nextInt(3) + 2) / 2;
            int radZ = (random.nextInt(5) + 4) / 2;
            for (BlockPos checking : Support.findUnsupportedPositions((BlockGetter)level, pos.m_142082_(-radX, -radY, -radZ), pos.m_142082_(radX, radY, radZ))) {
                if (!CollapseRecipe.canStartCollapse((LevelAccessor)level, checking)) continue;
                CollapseRecipe.startCollapse(level, checking);
                level.m_5594_(null, pos, (SoundEvent)TFCSounds.ROCK_SLIDE_LONG.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public static boolean canStartCollapse(LevelAccessor level, BlockPos pos) {
        return Helpers.isBlock(level.m_8055_(pos), TFCTags.Blocks.CAN_START_COLLAPSE) && TFCFallingBlockEntity.canFallInDirection((BlockGetter)level, pos, Direction.DOWN);
    }

    public static void startCollapse(Level world, BlockPos centerPos) {
        Random random = world.m_5822_();
        int radius = (Integer)TFCConfig.SERVER.collapseMinRadius.get() + random.nextInt((Integer)TFCConfig.SERVER.collapseRadiusVariance.get());
        int radiusSquared = radius * radius;
        ArrayList<BlockPos> secondaryPositions = new ArrayList<BlockPos>();
        block0: for (BlockPos pos : BlockPos.m_121940_((BlockPos)centerPos.m_142082_(-radius, -4, -radius), (BlockPos)centerPos.m_142082_(radius, -4, radius))) {
            boolean foundEmpty = false;
            for (int y = 0; y <= 8; ++y) {
                BlockPos posAt = pos.m_6630_(y);
                BlockState stateAt = world.m_8055_(posAt);
                if (foundEmpty && Helpers.isBlock(stateAt, TFCTags.Blocks.CAN_COLLAPSE) && posAt.m_123331_((Vec3i)centerPos) < (double)radiusSquared && (double)random.nextFloat() < (Double)TFCConfig.SERVER.collapsePropagateChance.get() && CollapseRecipe.collapseBlock(world, posAt, stateAt)) {
                    secondaryPositions.add(posAt.m_7494_());
                    continue block0;
                }
                if (!TFCFallingBlockEntity.canFallThrough((BlockGetter)world, posAt, Direction.DOWN)) continue;
                foundEmpty = true;
            }
        }
        if (!secondaryPositions.isEmpty()) {
            world.getCapability(WorldTrackerCapability.CAPABILITY).ifPresent(cap -> cap.addCollapseData(new Collapse(centerPos, secondaryPositions, radiusSquared)));
        }
    }

    public static boolean collapseBlock(Level world, BlockPos pos, BlockState state) {
        BlockInventory wrapper = new BlockInventory(pos, state);
        CollapseRecipe recipe = CollapseRecipe.getRecipe(world, wrapper);
        if (recipe != null) {
            BlockState collapseState = recipe.getBlockCraftingResult(wrapper);
            world.m_46597_(pos, collapseState);
            world.m_7967_((Entity)new TFCFallingBlockEntity(world, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, collapseState));
            return true;
        }
        return false;
    }

    CollapseRecipe(ResourceLocation id, BlockIngredient ingredient, BlockState outputState, boolean copyInputState) {
        super(id, ingredient, outputState, copyInputState);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.COLLAPSE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.COLLAPSE.get();
    }
}

