/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.SimpleItemRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LoomRecipe
extends SimpleItemRecipe {
    public static final IndirectHashCollection<Item, LoomRecipe> CACHE = IndirectHashCollection.createForRecipe(SimpleItemRecipe::getValidItems, TFCRecipeTypes.LOOM);
    private final int inputCount;
    private final int stepsRequired;
    private final ResourceLocation inProgressTexture;

    @Nullable
    public static LoomRecipe getRecipe(Level world, ItemStackInventory wrapper) {
        for (LoomRecipe recipe : CACHE.getAll(wrapper.getStack().m_41720_())) {
            if (!recipe.matches(wrapper, world)) continue;
            return recipe;
        }
        return null;
    }

    public LoomRecipe(ResourceLocation id, Ingredient ingredient, ItemStackProvider result, int inputCount, int stepsRequired, ResourceLocation inProgressTexture) {
        super(id, ingredient, result);
        this.inputCount = inputCount;
        this.stepsRequired = stepsRequired;
        this.inProgressTexture = inProgressTexture;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.LOOM.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.LOOM.get();
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public ResourceLocation getInProgressTexture() {
        return this.inProgressTexture;
    }

    public int getStepCount() {
        return this.stepsRequired;
    }

    public static class Serializer
    extends RecipeSerializerImpl<LoomRecipe> {
        public LoomRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "ingredient"));
            ItemStackProvider stack = ItemStackProvider.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"result"));
            int inputCount = JsonHelpers.m_13927_((JsonObject)json, (String)"input_count");
            int stepsRequired = JsonHelpers.m_13927_((JsonObject)json, (String)"steps_required");
            ResourceLocation inProgressTexture = new ResourceLocation(JsonHelpers.m_13906_((JsonObject)json, (String)"in_progress_texture"));
            return new LoomRecipe(recipeId, ingredient, stack, inputCount, stepsRequired, inProgressTexture);
        }

        @Nullable
        public LoomRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStackProvider stack = ItemStackProvider.fromNetwork(buffer);
            int inputCount = buffer.m_130242_();
            int steps = buffer.m_130242_();
            ResourceLocation inProgressTexture = new ResourceLocation(buffer.m_130277_());
            return new LoomRecipe(recipeId, ingredient, stack, inputCount, steps, inProgressTexture);
        }

        public void toNetwork(FriendlyByteBuf buffer, LoomRecipe recipe) {
            recipe.getIngredient().m_43923_(buffer);
            recipe.result.toNetwork(buffer);
            buffer.m_130130_(recipe.inputCount);
            buffer.m_130130_(recipe.stepsRequired);
            buffer.m_130070_(recipe.inProgressTexture.toString());
        }
    }
}

