/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonObject;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.recipes.BarrelRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class SealedBarrelRecipe
extends BarrelRecipe {
    private final int duration;
    @Nullable
    private final ItemStackProvider onSeal;
    @Nullable
    private final ItemStackProvider onUnseal;

    public SealedBarrelRecipe(ResourceLocation id, BarrelRecipe.Builder builder, int duration, @Nullable ItemStackProvider onSeal, @Nullable ItemStackProvider onUnseal) {
        super(id, builder);
        this.duration = duration;
        this.onSeal = onSeal;
        this.onUnseal = onUnseal;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isInfinite() {
        return this.duration <= 0;
    }

    @Nullable
    public ItemStackProvider getOnSeal() {
        return this.onSeal;
    }

    @Nullable
    public ItemStackProvider getOnUnseal() {
        return this.onUnseal;
    }

    public void onSealed(BarrelBlockEntity.BarrelInventory inventory) {
        if (this.onSeal != null) {
            inventory.whileMutable(() -> {
                ItemStack stack = Helpers.removeStack((IItemHandler)inventory, 2);
                inventory.insertItem(2, this.onSeal.getStack(stack), false);
            });
        }
    }

    public void onUnsealed(BarrelBlockEntity.BarrelInventory inventory) {
        if (this.onUnseal != null) {
            inventory.whileMutable(() -> {
                ItemStack stack = Helpers.removeStack((IItemHandler)inventory, 2);
                inventory.insertItem(2, this.onUnseal.getStack(stack), false);
            });
        }
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.BARREL_SEALED.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.SEALED_BARREL.get();
    }

    public static class Serializer
    extends RecipeSerializerImpl<SealedBarrelRecipe> {
        public SealedBarrelRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            BarrelRecipe.Builder builder = BarrelRecipe.Builder.fromJson(json);
            int duration = JsonHelpers.m_13927_((JsonObject)json, (String)"duration");
            ItemStackProvider onSeal = json.has("on_seal") ? ItemStackProvider.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"on_seal")) : null;
            ItemStackProvider onUnseal = json.has("on_unseal") ? ItemStackProvider.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"on_unseal")) : null;
            return new SealedBarrelRecipe(recipeId, builder, duration, onSeal, onUnseal);
        }

        @Nullable
        public SealedBarrelRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            BarrelRecipe.Builder builder = BarrelRecipe.Builder.fromNetwork(buffer);
            int duration = buffer.m_130242_();
            ItemStackProvider onSeal = Helpers.decodeNullable(buffer, ItemStackProvider::fromNetwork);
            ItemStackProvider onUnseal = Helpers.decodeNullable(buffer, ItemStackProvider::fromNetwork);
            return new SealedBarrelRecipe(recipeId, builder, duration, onSeal, onUnseal);
        }

        public void toNetwork(FriendlyByteBuf buffer, SealedBarrelRecipe recipe) {
            BarrelRecipe.Builder.toNetwork(recipe, buffer);
            buffer.m_130130_(recipe.duration);
            Helpers.encodeNullable(recipe.onSeal, buffer, ItemStackProvider::toNetwork);
            Helpers.encodeNullable(recipe.onUnseal, buffer, ItemStackProvider::toNetwork);
        }
    }
}

