/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SimplePotRecipe
extends PotRecipe {
    protected final FluidStack outputFluid;
    protected final List<ItemStack> outputStacks;

    protected SimplePotRecipe(ResourceLocation id, List<Ingredient> itemIngredients, FluidStackIngredient fluidIngredient, int duration, float minTemp, FluidStack outputFluid, List<ItemStack> outputStacks) {
        super(id, itemIngredients, fluidIngredient, duration, minTemp);
        this.outputFluid = outputFluid;
        this.outputStacks = outputStacks;
        this.outputStacks.forEach(FoodCapability::setStackNonDecaying);
    }

    public FluidStack getDisplayFluid() {
        return this.outputFluid;
    }

    public List<ItemStack> getOutputStacks() {
        return this.outputStacks;
    }

    @Override
    public PotRecipe.Output getOutput(PotBlockEntity.PotInventory inventory) {
        return new SimpleOutput(this.outputFluid, this.outputStacks);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.POT_SIMPLE.get();
    }

    record SimpleOutput(FluidStack stack, List<ItemStack> items) implements PotRecipe.Output
    {
        @Override
        public void onFinish(PotBlockEntity.PotInventory inventory) {
            for (int i = 0; i < Math.min(this.items.size(), inventory.getSlots()); ++i) {
                inventory.setStackInSlot(i, this.items.get(i).m_41777_());
            }
            inventory.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            inventory.fill(this.stack.copy(), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public static class Serializer
    extends PotRecipe.Serializer<SimplePotRecipe> {
        @Override
        public void toNetwork(FriendlyByteBuf buffer, SimplePotRecipe recipe) {
            super.toNetwork(buffer, recipe);
            buffer.writeFluidStack(recipe.outputFluid);
            buffer.m_130130_(recipe.outputStacks.size());
            recipe.outputStacks.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130055_(arg_0));
        }

        @Override
        protected SimplePotRecipe fromJson(ResourceLocation recipeId, JsonObject json, List<Ingredient> ingredients, FluidStackIngredient fluidIngredient, int duration, float minTemp) {
            FluidStack output = json.has("fluid_output") ? JsonHelpers.getFluidStack(json, "fluid_output") : FluidStack.EMPTY;
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(5);
            if (json.has("item_output")) {
                JsonArray array = json.getAsJsonArray("item_output");
                for (JsonElement element : array) {
                    ItemStack stack = JsonHelpers.getItemStack(element.getAsJsonObject());
                    if (stack.m_41613_() != 1) {
                        throw new JsonParseException("Item stacks for pot outputs must be of size 1");
                    }
                    stacks.add(stack);
                }
            }
            if (stacks.size() > 5) {
                throw new JsonParseException("Cannot have more than five item stack outputs for pot recipe.");
            }
            return new SimplePotRecipe(recipeId, ingredients, fluidIngredient, duration, minTemp, output, stacks);
        }

        @Override
        protected SimplePotRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer, List<Ingredient> ingredients, FluidStackIngredient fluidIngredient, int duration, float minTemp) {
            FluidStack fluid = buffer.readFluidStack();
            int size = buffer.m_130242_();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(size);
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    stacks.add(buffer.m_130267_());
                }
            }
            return new SimplePotRecipe(recipeId, ingredients, fluidIngredient, duration, minTemp, fluid, stacks);
        }
    }
}

