/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.inventory.EmptyInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WeldingRecipe
implements ISimpleRecipe<Inventory> {
    private final ResourceLocation id;
    private final Ingredient firstInput;
    private final Ingredient secondInput;
    private final int tier;
    private final ItemStackProvider output;

    public WeldingRecipe(ResourceLocation id, Ingredient firstInput, Ingredient secondInput, int tier, ItemStackProvider output) {
        this.id = id;
        this.firstInput = firstInput;
        this.secondInput = secondInput;
        this.tier = tier;
        this.output = output;
    }

    public int getTier() {
        return this.tier;
    }

    public boolean matches(Inventory inventory, Level level) {
        ItemStack left = inventory.getLeft();
        ItemStack right = inventory.getRight();
        return this.firstInput.test(left) && this.secondInput.test(right) || this.firstInput.test(right) && this.secondInput.test(left);
    }

    public ItemStack assemble(Inventory inventory) {
        return this.output.getSingleStack(inventory.getLeft());
    }

    public ItemStack m_8043_() {
        return this.output.getEmptyStack();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.WELDING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.WELDING.get();
    }

    public Ingredient getFirstInput() {
        return this.firstInput;
    }

    public Ingredient getSecondInput() {
        return this.secondInput;
    }

    public static interface Inventory
    extends EmptyInventory {
        public ItemStack getLeft();

        public ItemStack getRight();

        public int getTier();
    }

    public static class Serializer
    extends RecipeSerializerImpl<WeldingRecipe> {
        public WeldingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient firstInput = Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "first_input"));
            Ingredient secondInput = Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "second_input"));
            int tier = JsonHelpers.m_13824_((JsonObject)json, (String)"tier", (int)-1);
            ItemStackProvider output = ItemStackProvider.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"result"));
            return new WeldingRecipe(recipeId, firstInput, secondInput, tier, output);
        }

        @Nullable
        public WeldingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient firstInput = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient secondInput = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int tier = buffer.m_130242_();
            ItemStackProvider output = ItemStackProvider.fromNetwork(buffer);
            return new WeldingRecipe(recipeId, firstInput, secondInput, tier, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, WeldingRecipe recipe) {
            recipe.firstInput.m_43923_(buffer);
            recipe.secondInput.m_43923_(buffer);
            buffer.m_130130_(recipe.tier);
            recipe.output.toNetwork(buffer);
        }
    }
}

