/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public abstract class DelegateIngredient
extends Ingredient {
    @Nullable
    protected final Ingredient delegate;
    private ItemStack @Nullable [] cachedItemStacks;
    @Nullable
    private IntList stackingIds;

    public DelegateIngredient(@Nullable Ingredient delegate) {
        super(Stream.empty());
        this.delegate = delegate;
        this.cachedItemStacks = null;
        this.stackingIds = null;
    }

    public final ItemStack[] m_43908_() {
        if (this.cachedItemStacks == null || this.checkInvalidation()) {
            this.cachedItemStacks = this.delegate != null ? (ItemStack[])Arrays.stream(this.delegate.m_43908_()).map(ItemStack::m_41777_).map(this::testDefaultItem).filter(Objects::nonNull).toArray(ItemStack[]::new) : this.getDefaultItems();
        }
        return this.cachedItemStacks;
    }

    public boolean test(@Nullable ItemStack stack) {
        return this.delegate == null || this.delegate.test(stack);
    }

    public final IntList m_43931_() {
        if (this.stackingIds == null || this.checkInvalidation()) {
            ItemStack[] itemStacks = this.m_43908_();
            this.stackingIds = new IntArrayList(itemStacks.length);
            for (ItemStack stack : itemStacks) {
                this.stackingIds.add(StackedContents.m_36496_((ItemStack)stack));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public JsonElement m_43942_() {
        return this.delegate != null ? this.delegate.m_43942_() : JsonNull.INSTANCE;
    }

    public boolean m_43947_() {
        return this.delegate != null && this.delegate.m_43947_();
    }

    protected void invalidate() {
        this.cachedItemStacks = null;
        this.stackingIds = null;
    }

    public boolean isSimple() {
        return this.delegate != null && this.delegate.isSimple();
    }

    public abstract IIngredientSerializer<? extends DelegateIngredient> getSerializer();

    protected ItemStack[] getDefaultItems() {
        return (ItemStack[])ForgeRegistries.ITEMS.getValues().stream().map(item -> {
            ItemStack stack = new ItemStack((ItemLike)item);
            return this.testDefaultItem(stack);
        }).filter(Objects::nonNull).toArray(ItemStack[]::new);
    }

    @Nullable
    protected ItemStack testDefaultItem(ItemStack stack) {
        return stack;
    }
}

