/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class FluidIngredient
implements Predicate<Fluid> {
    private final List<Entry> entries;

    public static FluidIngredient of(Fluid ... fluids) {
        return new FluidIngredient(Arrays.stream(fluids).map(FluidEntry::new));
    }

    public static FluidIngredient of(TagKey<Fluid> tag) {
        return new FluidIngredient(Stream.of(new TagEntry(tag)));
    }

    public static FluidIngredient of(FluidIngredient ... others) {
        return new FluidIngredient(Arrays.stream(others).flatMap(e -> e.entries.stream()));
    }

    public static FluidIngredient fromJson(JsonElement json) {
        if (json.isJsonPrimitive()) {
            return new FluidIngredient(Collections.singletonList(new FluidEntry((Fluid)JsonHelpers.getRegistryEntry(json, ForgeRegistries.FLUIDS))));
        }
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("fluid") && obj.has("tag")) {
                throw new JsonParseException("Fluid ingredient cannot have both 'fluid' and 'tag' entries");
            }
            if (obj.has("fluid")) {
                return FluidIngredient.of((Fluid)JsonHelpers.getRegistryEntry(obj, "fluid", ForgeRegistries.FLUIDS));
            }
            if (obj.has("tag")) {
                return FluidIngredient.of(JsonHelpers.getTag(obj, "tag", Registry.f_122899_));
            }
            throw new JsonParseException("Fluid ingredient must have one of 'fluid' or 'tag' entries");
        }
        JsonArray array = JsonHelpers.m_13924_((JsonElement)json, (String)"fluid ingredient");
        ArrayList<FluidIngredient> entries = new ArrayList<FluidIngredient>();
        for (JsonElement element : array) {
            entries.add(FluidIngredient.fromJson(element));
        }
        return new FluidIngredient(entries.stream().flatMap(e -> e.entries.stream()));
    }

    public static FluidIngredient fromNetwork(FriendlyByteBuf buffer) {
        return new FluidIngredient(Helpers.decodeAll(buffer, new ArrayList(), Entry::fromNetwork));
    }

    public static void toNetwork(FriendlyByteBuf buffer, FluidIngredient ingredient) {
        Helpers.encodeAll(buffer, ingredient.entries, Entry::toNetwork);
    }

    private FluidIngredient(Stream<Entry> entries) {
        this(entries.toList());
    }

    private FluidIngredient(List<Entry> entries) {
        this.entries = entries;
    }

    @Override
    public boolean test(Fluid fluid) {
        for (Entry entry : this.entries) {
            if (!entry.test(fluid)) continue;
            return true;
        }
        return false;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        Helpers.encodeAll(buffer, this.entries, Entry::toNetwork);
    }

    public Collection<Fluid> getMatchingFluids() {
        return this.entries.stream().flatMap(Entry::fluids).toList();
    }

    private record TagEntry(TagKey<Fluid> tag) implements Entry
    {
        @Override
        public boolean test(Fluid fluid) {
            return Helpers.isFluid(fluid, this.tag);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeByte(1);
            buffer.m_130085_(this.tag.f_203868_());
        }

        @Override
        public Stream<Fluid> fluids() {
            return Helpers.getAllTagValues(this.tag, ForgeRegistries.FLUIDS).stream();
        }
    }

    private record FluidEntry(Fluid fluid) implements Entry
    {
        @Override
        public boolean test(Fluid fluid) {
            return this.fluid == fluid;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeByte(0);
            buffer.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, (IForgeRegistryEntry)this.fluid);
        }

        @Override
        public Stream<Fluid> fluids() {
            return Stream.of(this.fluid);
        }
    }

    private static interface Entry
    extends Predicate<Fluid> {
        public static Entry fromNetwork(FriendlyByteBuf buffer) {
            byte id = buffer.readByte();
            if (id == 0) {
                Fluid fluid = (Fluid)buffer.readRegistryIdUnsafe(ForgeRegistries.FLUIDS);
                return new FluidEntry(fluid);
            }
            if (id == 1) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)buffer.m_130281_());
                return new TagEntry((TagKey<Fluid>)tag);
            }
            throw new IllegalArgumentException("Illegal id: " + id);
        }

        public void toNetwork(FriendlyByteBuf var1);

        public Stream<Fluid> fluids();
    }
}

