/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredients;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SimpleBlockIngredient
implements BlockIngredient {
    private final Set<Block> blocks;

    SimpleBlockIngredient(Block block) {
        this.blocks = Collections.singleton(block);
    }

    SimpleBlockIngredient(Collection<Block> blocks) {
        this.blocks = new ObjectOpenHashSet(blocks);
    }

    @Override
    public boolean test(BlockState state) {
        return this.blocks.contains(state.m_60734_());
    }

    @Override
    public Collection<Block> getValidBlocks() {
        return this.blocks;
    }

    @Override
    public BlockIngredient.Serializer<?> serializer() {
        return Serializer.INSTANCE;
    }

    public static enum Serializer implements BlockIngredient.Serializer<SimpleBlockIngredient>
    {
        INSTANCE;


        @Override
        public SimpleBlockIngredient fromJson(JsonObject json) {
            return BlockIngredients.fromJsonString(GsonHelper.m_13906_((JsonObject)json, (String)"block"));
        }

        @Override
        public SimpleBlockIngredient fromNetwork(FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            if (size == 1) {
                return new SimpleBlockIngredient((Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS));
            }
            HashSet<Block> blocks = new HashSet<Block>();
            for (int i = 0; i < size; ++i) {
                blocks.add((Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS));
            }
            return new SimpleBlockIngredient(blocks);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer, SimpleBlockIngredient ingredient) {
            buffer.m_130130_(ingredient.blocks.size());
            for (Block block : ingredient.blocks) {
                buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (IForgeRegistryEntry)block);
            }
        }
    }
}

