/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.google.gson.JsonObject;
import java.util.Collection;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public record TagBlockIngredient(TagKey<Block> tag) implements BlockIngredient
{
    @Override
    public boolean test(BlockState state) {
        return Helpers.isBlock(state, this.tag);
    }

    @Override
    public Collection<Block> getValidBlocks() {
        return Helpers.getAllTagValues(this.tag, ForgeRegistries.BLOCKS);
    }

    @Override
    public BlockIngredient.Serializer<?> serializer() {
        return Serializer.INSTANCE;
    }

    public static enum Serializer implements BlockIngredient.Serializer<TagBlockIngredient>
    {
        INSTANCE;


        @Override
        public TagBlockIngredient fromJson(JsonObject json) {
            return new TagBlockIngredient(JsonHelpers.getTag(json, "tag", Registry.f_122901_));
        }

        @Override
        public TagBlockIngredient fromNetwork(FriendlyByteBuf buffer) {
            return new TagBlockIngredient(JsonHelpers.getTag(buffer.m_130281_().toString(), Registry.f_122901_));
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer, TagBlockIngredient ingredient) {
            buffer.m_130085_(ingredient.tag.f_203868_());
        }
    }
}

