/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.outputs;

import com.google.gson.JsonObject;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifier;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public record AddRemoveTraitModifier(boolean add, FoodTrait trait) implements ItemStackModifier
{
    @Override
    public ItemStack apply(ItemStack stack, ItemStack input) {
        return this.add ? FoodCapability.applyTrait(stack, this.trait) : FoodCapability.removeTrait(stack, this.trait);
    }

    public Serializer serializer() {
        return this.add ? Serializer.ADD : Serializer.REMOVE;
    }

    public record Serializer(boolean add) implements ItemStackModifier.Serializer<AddRemoveTraitModifier>
    {
        static final Serializer ADD = new Serializer(true);
        static final Serializer REMOVE = new Serializer(false);

        @Override
        public AddRemoveTraitModifier fromJson(JsonObject json) {
            FoodTrait trait = FoodTrait.getTraitOrThrow(new ResourceLocation(JsonHelpers.m_13906_((JsonObject)json, (String)"trait")));
            return new AddRemoveTraitModifier(this.add, trait);
        }

        @Override
        public AddRemoveTraitModifier fromNetwork(FriendlyByteBuf buffer) {
            FoodTrait trait = FoodTrait.getTraitOrThrow(new ResourceLocation(buffer.m_130277_()));
            return new AddRemoveTraitModifier(this.add, trait);
        }

        @Override
        public void toNetwork(AddRemoveTraitModifier modifier, FriendlyByteBuf buffer) {
            buffer.m_130085_(FoodTrait.getId(modifier.trait));
        }
    }
}

