/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.outputs;

import java.util.ArrayList;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodData;
import net.dries007.tfc.common.capabilities.food.FoodHandler;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifier;
import net.dries007.tfc.util.Helpers;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;

public enum SandwichModifier implements ItemStackModifier.SingleInstance<SandwichModifier>
{
    INSTANCE;


    @Override
    public ItemStack apply(ItemStack stack, ItemStack input) {
        CraftingContainer inv = RecipeHelpers.getCraftingContainer();
        if (inv != null) {
            stack.getCapability(FoodCapability.CAPABILITY).ifPresent(food -> {
                if (food instanceof FoodHandler.Dynamic) {
                    FoodHandler.Dynamic dynamic = (FoodHandler.Dynamic)food;
                    this.initFoodStats(inv, dynamic);
                }
            });
            return stack;
        }
        return stack;
    }

    private void initFoodStats(CraftingContainer inv, FoodHandler.Dynamic handler) {
        ArrayList ingredients = new ArrayList(3);
        ItemStack breadItem1 = ItemStack.f_41583_;
        ItemStack breadItem2 = ItemStack.f_41583_;
        boolean checkBread = true;
        for (int index = 0; index < inv.m_6643_(); ++index) {
            ItemStack item = inv.m_8020_(index);
            if (checkBread && Helpers.isItem(item, TFCTags.Items.SANDWICH_BREAD)) {
                if (breadItem1.m_41619_()) {
                    breadItem1 = item;
                    continue;
                }
                if (breadItem2.m_41619_()) {
                    breadItem2 = item;
                    continue;
                }
                checkBread = false;
            }
            item.getCapability(FoodCapability.CAPABILITY).map(IFood::getData).ifPresent(ingredients::add);
        }
        FoodData bread1 = breadItem1.getCapability(FoodCapability.CAPABILITY).map(IFood::getData).orElse(FoodData.EMPTY);
        FoodData bread2 = breadItem2.getCapability(FoodCapability.CAPABILITY).map(IFood::getData).orElse(FoodData.EMPTY);
        float[] nutrition = new float[Nutrient.TOTAL];
        float saturation = 1.0f + 0.5f * (bread1.saturation() + bread2.saturation());
        float water = 0.5f * (bread1.water() + bread2.water());
        for (Nutrient nutrient : Nutrient.VALUES) {
            nutrition[nutrient.ordinal()] = 0.5f * (bread1.nutrient(nutrient) + bread2.nutrient(nutrient));
        }
        for (FoodData ingredient : ingredients) {
            for (Nutrient nutrient : Nutrient.VALUES) {
                int n = nutrient.ordinal();
                nutrition[n] = nutrition[n] + 0.8f * ingredient.nutrient(nutrient);
            }
            saturation += 0.8f * ingredient.saturation();
            water += 0.8f * ingredient.water();
        }
        handler.setFood(FoodData.create(4, water, saturation, nutrition, 4.5f));
        handler.setCreationDate(FoodCapability.getRoundedCreationDate());
    }

    @Override
    public SandwichModifier instance() {
        return INSTANCE;
    }
}

