/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.patchouli;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import vazkii.patchouli.client.RenderHelper;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.common.util.ItemStackUtil;

public final class PatchouliClientEventHandler {
    private static float lexiconLookupTime = 0.0f;

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(PatchouliClientEventHandler::renderBookTooltipWithoutBook);
    }

    public static void renderBookTooltipWithoutBook(RenderTooltipEvent.Pre event) {
        if (!((Boolean)TFCConfig.CLIENT.showGuideBookLinksAlways.get()).booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        PoseStack poseStack = event.getPoseStack();
        ItemStack stack = event.getItemStack();
        int tooltipX = event.getX();
        int tooltipY = event.getY() - 4;
        if (PatchouliClientEventHandler.wouldPatchouliRenderATooltipHere(minecraft, stack)) {
            return;
        }
        Book book = (Book)BookRegistry.INSTANCE.books.get(PatchouliIntegration.BOOK_ID);
        Pair entry = book.getContents().getEntryForStack(stack);
        if (entry != null && !((BookEntry)entry.getFirst()).isLocked()) {
            ItemStack bookStack = ItemModBook.forBook((Book)book);
            int x = tooltipX - 34;
            RenderSystem.m_69465_();
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(x - 4), (int)(tooltipY - 4), (int)(x + 20), (int)(tooltipY + 26), (int)0x44000000);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(x - 6), (int)(tooltipY - 6), (int)(x + 22), (int)(tooltipY + 28), (int)0x44000000);
            if ((Boolean)PatchouliConfig.get().useShiftForQuickLookup().get() != false ? Screen.m_96638_() : Screen.m_96637_()) {
                int cx = x + 8;
                int cy = tooltipY + 8;
                float r = 12.0f;
                float time = 20.0f;
                float angles = (lexiconLookupTime += ClientTicker.delta) / time * 360.0f;
                RenderSystem.m_69472_();
                RenderSystem.m_69478_();
                RenderSystem.m_69405_((int)770, (int)771);
                BufferBuilder buf = Tesselator.m_85913_().m_85915_();
                buf.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
                float a = 0.5f + 0.2f * ((float)Math.cos(ClientTicker.total / 10.0f) * 0.5f + 0.5f);
                buf.m_5483_((double)cx, (double)cy, 0.0).m_85950_(0.0f, 0.5f, 0.0f, a).m_5752_();
                for (float i = angles; i > 0.0f; i -= 1.0f) {
                    double rad = (double)((i - 90.0f) / 180.0f) * Math.PI;
                    buf.m_5483_((double)cx + Math.cos(rad) * (double)r, (double)cy + Math.sin(rad) * (double)r, 0.0).m_85950_(0.0f, 1.0f, 0.0f, 1.0f).m_5752_();
                }
                buf.m_5483_((double)cx, (double)cy, 0.0).m_85950_(0.0f, 1.0f, 0.0f, 0.0f).m_5752_();
                Tesselator.m_85913_().m_85914_();
                RenderSystem.m_69461_();
                RenderSystem.m_69493_();
                if (lexiconLookupTime >= time) {
                    int spread = (Integer)entry.getSecond();
                    ClientBookRegistry.INSTANCE.displayBookGui(book.id, ((BookEntry)entry.getFirst()).getId(), spread * 2);
                }
            } else {
                lexiconLookupTime = 0.0f;
            }
            minecraft.m_91291_().f_115093_ = 300.0f;
            RenderHelper.renderItemStackInGui((PoseStack)poseStack, (ItemStack)bookStack, (int)x, (int)tooltipY);
            minecraft.m_91291_().f_115093_ = 0.0f;
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 500.0);
            minecraft.f_91062_.m_92750_(poseStack, "?", (float)(x + 10), (float)(tooltipY + 8), -1);
            poseStack.m_85841_(0.5f, 0.5f, 1.0f);
            boolean mac = Minecraft.f_91002_;
            MutableComponent key = Helpers.literal((Boolean)PatchouliConfig.get().useShiftForQuickLookup().get() != false ? "Shift" : (mac ? "Cmd" : "Ctrl")).m_130940_(ChatFormatting.BOLD);
            minecraft.f_91062_.m_92763_(poseStack, (Component)key, (float)((x + 10) * 2 - 16), (float)((tooltipY + 8) * 2 + 20), -1);
            poseStack.m_85849_();
            RenderSystem.m_69482_();
        } else {
            lexiconLookupTime = 0.0f;
        }
    }

    private static boolean wouldPatchouliRenderATooltipHere(Minecraft minecraft, ItemStack stack) {
        if (minecraft.f_91074_ != null && !(minecraft.f_91080_ instanceof GuiBook)) {
            for (int i = 0; i < Inventory.m_36059_(); ++i) {
                Pair entry;
                Book book;
                ItemStack stackAt = minecraft.f_91074_.m_150109_().m_8020_(i);
                if (stackAt.m_41619_() || (book = ItemStackUtil.getBookFromStack((ItemStack)stackAt)) == null || (entry = book.getContents().getEntryForStack(stack)) == null || ((BookEntry)entry.getFirst()).isLocked()) continue;
                return true;
            }
        }
        return false;
    }
}

