/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataCache;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.chunkdata.LerpFloatLayer;
import net.dries007.tfc.world.chunkdata.PlateTectonicsClassification;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class ChunkWatchPacket {
    private final int chunkX;
    private final int chunkZ;
    @Nullable
    private final LerpFloatLayer rainfallLayer;
    @Nullable
    private final LerpFloatLayer temperatureLayer;
    private final ForestType forestType;
    private final float forestWeirdness;
    private final float forestDensity;
    private final PlateTectonicsClassification plateTectonicsInfo;

    public ChunkWatchPacket(int chunkX, int chunkZ, @Nullable LerpFloatLayer rainfallLayer, @Nullable LerpFloatLayer temperatureLayer, ForestType forestType, float forestDensity, float forestWeirdness, PlateTectonicsClassification plateTectonicsInfo) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.rainfallLayer = rainfallLayer;
        this.temperatureLayer = temperatureLayer;
        this.forestType = forestType;
        this.forestDensity = forestDensity;
        this.forestWeirdness = forestWeirdness;
        this.plateTectonicsInfo = plateTectonicsInfo;
    }

    ChunkWatchPacket(FriendlyByteBuf buffer) {
        this.chunkX = buffer.m_130242_();
        this.chunkZ = buffer.m_130242_();
        this.rainfallLayer = Helpers.decodeNullable(buffer, LerpFloatLayer::new);
        this.temperatureLayer = Helpers.decodeNullable(buffer, LerpFloatLayer::new);
        this.forestType = ForestType.valueOf(buffer.readByte());
        this.forestDensity = buffer.readFloat();
        this.forestWeirdness = buffer.readFloat();
        this.plateTectonicsInfo = PlateTectonicsClassification.valueOf(buffer.readByte());
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.chunkX);
        buffer.m_130130_(this.chunkZ);
        Helpers.encodeNullable(this.rainfallLayer, buffer, LerpFloatLayer::encode);
        Helpers.encodeNullable(this.temperatureLayer, buffer, LerpFloatLayer::encode);
        buffer.writeByte(this.forestType.ordinal());
        buffer.writeFloat(this.forestDensity);
        buffer.writeFloat(this.forestWeirdness);
        buffer.writeByte(this.plateTectonicsInfo.ordinal());
    }

    void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ChunkPos pos = new ChunkPos(this.chunkX, this.chunkZ);
            Level world = ClientHelpers.getLevel();
            if (world != null) {
                LevelChunk chunk = world.m_7232_(this.chunkX, this.chunkZ) ? world.m_6325_(this.chunkX, this.chunkZ) : null;
                ChunkData data = ChunkData.getCapability(chunk).map(dataIn -> {
                    ChunkDataCache.CLIENT.update(pos, (ChunkData)dataIn);
                    return dataIn;
                }).orElseGet(() -> ChunkDataCache.CLIENT.computeIfAbsent(pos, ChunkData::createClient));
                data.onUpdatePacket(this.rainfallLayer, this.temperatureLayer, this.forestType, this.forestDensity, this.forestWeirdness, this.plateTectonicsInfo);
            }
        });
    }
}

