/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import net.dries007.tfc.common.container.TFCContainerProviders;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class SwitchInventoryTabPacket {
    private final Type type;

    public SwitchInventoryTabPacket(Type type) {
        this.type = type;
    }

    SwitchInventoryTabPacket(FriendlyByteBuf buffer) {
        this.type = Type.VALUES[buffer.readByte()];
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.writeByte(this.type.ordinal());
    }

    void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                player.m_9230_();
                switch (this.type) {
                    case INVENTORY: {
                        player.f_36096_ = player.f_36095_;
                        break;
                    }
                    case CALENDAR: {
                        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)TFCContainerProviders.CALENDAR);
                        break;
                    }
                    case NUTRITION: {
                        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)TFCContainerProviders.NUTRITION);
                        break;
                    }
                    case CLIMATE: {
                        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)TFCContainerProviders.CLIMATE);
                        break;
                    }
                    case BOOK: {
                        PatchouliIntegration.openGui(player);
                    }
                }
            }
        });
    }

    public static enum Type {
        INVENTORY,
        CALENDAR,
        NUTRITION,
        CLIMATE,
        BOOK;

        private static final Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }
}

