/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.Collections;
import java.util.function.Supplier;
import net.dries007.tfc.util.InteractionManager;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class BlockItemPlacement
implements InteractionManager.OnItemUseAction {
    private final Supplier<? extends Item> item;
    private final Supplier<? extends Block> block;

    public static boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.m_43725_().m_7731_(context.m_8083_(), state, 11);
    }

    public static boolean canPlace(BlockPlaceContext context, BlockState stateToPlace) {
        Player player = context.m_43723_();
        CollisionContext selectionContext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return stateToPlace.m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) && context.m_43725_().m_45752_(stateToPlace, context.m_8083_(), selectionContext);
    }

    public static BlockState updateBlockStateFromTag(BlockPos pos, Level world, ItemStack stack, BlockState state) {
        BlockState newState = state;
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            CompoundTag blockStateNbt = nbt.m_128469_("BlockStateTag");
            StateDefinition container = state.m_60734_().m_49965_();
            for (String propertyKey : blockStateNbt.m_128431_()) {
                Property property = container.m_61081_(propertyKey);
                if (property == null) continue;
                String s1 = blockStateNbt.m_128423_(propertyKey).m_7916_();
                newState = BlockItemPlacement.updateState(newState, property, s1);
            }
        }
        if (newState != state) {
            world.m_7731_(pos, newState, 2);
        }
        return newState;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState state, Property<T> property, String value) {
        return property.m_6215_(value).map(valueIn -> (BlockState)state.m_61124_(property, valueIn)).orElse(state);
    }

    public BlockItemPlacement(Supplier<? extends Item> item, Supplier<? extends Block> block) {
        this.item = item;
        this.block = block;
    }

    public Iterable<Item> getItems() {
        return Collections.singleton(this.item.get());
    }

    public Item getItem() {
        return this.item.get();
    }

    @Override
    public InteractionResult onItemUse(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player != null && !player.m_150110_().f_35938_) {
            return InteractionResult.PASS;
        }
        Item item = this.getItem();
        InteractionResult result = this.place(new BlockPlaceContext(context));
        if (player != null && result.m_19077_()) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
        }
        return result;
    }

    public InteractionResult place(BlockPlaceContext context) {
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockState placementState = this.getPlacementState(context);
        if (placementState == null) {
            return InteractionResult.FAIL;
        }
        if (!BlockItemPlacement.placeBlock(context, placementState)) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        BlockState placedState = world.m_8055_(pos);
        Block placedBlock = placedState.m_60734_();
        if (placedBlock == placementState.m_60734_()) {
            placedState = BlockItemPlacement.updateBlockStateFromTag(pos, world, stack, placedState);
            BlockItem.m_40582_((Level)world, (Player)player, (BlockPos)pos, (ItemStack)stack);
            placedBlock.m_6402_(world, pos, placedState, (LivingEntity)player, stack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, pos, stack);
            }
        }
        SoundType placementSound = placedState.getSoundType((LevelReader)world, pos, (Entity)player);
        world.m_5594_(player, pos, placedState.getSoundType((LevelReader)world, pos, (Entity)player).m_56777_(), SoundSource.BLOCKS, (placementSound.m_56773_() + 1.0f) / 2.0f, placementSound.m_56774_() * 0.8f);
        if (player == null || !player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState placementState = this.block.get().m_5573_(context);
        return placementState != null && BlockItemPlacement.canPlace(context, placementState) ? placementState : null;
    }
}

