/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.capabilities.SimpleFluidHandler;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.items.TFCItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public final class CauldronInteractions {
    private static final BiMap<Block, Fluid> CAULDRONS = HashBiMap.create();

    public static void registerCauldronInteractions() {
        CauldronInteractions.registerForVanillaCauldrons((Item)TFCItems.WOODEN_BUCKET.get(), CauldronInteractions::interactWithBucket);
        TFCItems.FLUID_BUCKETS.values().forEach(reg -> CauldronInteractions.registerForVanillaCauldrons((Item)reg.get(), CauldronInteractions::interactWithBucket));
        CauldronInteractions.registerForVanillaCauldrons((Item)TFCItems.RED_STEEL_BUCKET.get(), CauldronInteractions::interactWithBucket);
        CauldronInteractions.registerForVanillaCauldrons((Item)TFCItems.BLUE_STEEL_BUCKET.get(), CauldronInteractions::interactWithBucket);
        TFCBlocks.CAULDRONS.forEach((type, reg) -> CauldronInteractions.registerCauldronBlock((Block)reg.get(), type.fluid().get()));
        CauldronInteractions.registerCauldronBlock(Blocks.f_50256_, Fluids.f_76191_);
        CauldronInteractions.registerCauldronBlock(Blocks.f_152476_, (Fluid)Fluids.f_76193_);
        CauldronInteractions.registerCauldronBlock(Blocks.f_152477_, (Fluid)Fluids.f_76195_);
    }

    public static void registerCauldronBlock(Block cauldron, Fluid fluid) {
        CAULDRONS.put((Object)cauldron, (Object)fluid);
    }

    public static void registerForVanillaCauldrons(Item item, CauldronInteraction interaction) {
        CauldronInteraction.f_175606_.put(item, interaction);
        CauldronInteraction.f_175607_.put(item, interaction);
        CauldronInteraction.f_175608_.put(item, interaction);
    }

    public static IFluidHandler createFluidHandler(Level level, BlockPos pos) {
        return new CauldronBlockHandler(level, pos);
    }

    public static InteractionResult interactWithBucket(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        if (FluidHelpers.transferBetweenBlockHandlerAndItem(stack, CauldronInteractions.createFluidHandler(level, pos), level, pos, new FluidHelpers.AfterTransferWithPlayer(player, hand))) {
            player.m_36220_(Stats.f_12944_);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    record CauldronBlockHandler(Level level, BlockPos pos) implements SimpleFluidHandler
    {
        @NotNull
        public FluidStack getFluidInTank(int tank) {
            Fluid fluid = (Fluid)CAULDRONS.get((Object)this.level.m_8055_(this.pos).m_60734_());
            return fluid != null ? new FluidStack(fluid, 1000) : FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return CAULDRONS.inverse().containsKey((Object)stack.getFluid());
        }

        public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
            if (this.getFluidInTank(0).isEmpty() && this.isFluidValid(0, stack) && stack.getAmount() >= 1000) {
                Block block = (Block)CAULDRONS.inverse().get((Object)stack.getFluid());
                if (!action.simulate()) {
                    BlockState state = block.m_49966_();
                    if (state.m_61138_((Property)BlockStateProperties.f_61418_)) {
                        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61418_, (Comparable)Integer.valueOf(3));
                    }
                    this.level.m_46597_(this.pos, state);
                }
                return 1000;
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack stack = this.getFluidInTank(0);
            if (!stack.isEmpty() && maxDrain >= 1000) {
                if (!action.simulate()) {
                    this.level.m_46597_(this.pos, Blocks.f_50256_.m_49966_());
                }
                return stack;
            }
            return FluidStack.EMPTY;
        }
    }
}

