/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.stream.Stream;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.items.TFCMinecartItem;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.RegistryObject;

public final class DispenserBehaviors {
    public static final DispenseItemBehavior DEFAULT = new DefaultDispenseItemBehavior();
    public static final DispenseItemBehavior VANILLA_BUCKET_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BucketItem bucket = (BucketItem)stack.m_41720_();
            BlockPos pos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            ServerLevel level = source.m_7727_();
            if (bucket.m_142073_(null, (Level)level, pos, null)) {
                bucket.m_142131_(null, (Level)level, stack, pos);
                return new ItemStack((ItemLike)Items.f_42446_);
            }
            return DEFAULT.m_6115_(source, stack);
        }
    };
    public static final DispenseItemBehavior TFC_BUCKET_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BlockPos dropPos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            ServerLevel level = source.m_7727_();
            return stack.getCapability(Capabilities.FLUID_ITEM).map(arg_0 -> 2.lambda$execute$0((Level)level, dropPos, stack, source, arg_0)).orElse(DEFAULT.m_6115_(source, stack));
        }

        private static /* synthetic */ ItemStack lambda$execute$0(Level level, BlockPos dropPos, ItemStack stack, BlockSource source, IFluidHandlerItem handler) {
            if (FluidHelpers.emptyFluidFrom((IFluidHandler)handler, level, dropPos, level.m_8055_(dropPos), null, true)) {
                return stack.getContainerItem();
            }
            return DEFAULT.m_6115_(source, stack);
        }
    };
    public static final DispenseItemBehavior CHEST_BEHAVIOR = new OptionalDispenseItemBehavior(){

        public ItemStack m_7498_(BlockSource level, ItemStack stack) {
            BlockPos blockpos = level.m_7961_().m_142300_((Direction)level.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            for (AbstractChestedHorse horse2 : level.m_7727_().m_6443_(AbstractChestedHorse.class, new AABB(blockpos), horse -> horse.m_6084_() && !horse.m_30502_())) {
                if (!horse2.m_30614_() || !horse2.m_141942_(499).m_142104_(stack)) continue;
                stack.m_41774_(1);
                this.m_123573_(true);
                return stack;
            }
            return super.m_7498_(level, stack);
        }
    };
    public static DispenseItemBehavior MINECART_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            Item item = stack.m_41720_();
            if (item instanceof TFCMinecartItem) {
                double offset;
                RailShape railshape;
                TFCMinecartItem cartItem = (TFCMinecartItem)item;
                Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                ServerLevel level = source.m_7727_();
                double x = source.m_7096_() + (double)direction.m_122429_() * 1.125;
                double y = Math.floor(source.m_7098_()) + (double)direction.m_122430_();
                double z = source.m_7094_() + (double)direction.m_122431_() * 1.125;
                BlockPos offsetPos = source.m_7961_().m_142300_(direction);
                BlockState state = level.m_8055_(offsetPos);
                RailShape railShape = railshape = state.m_60734_() instanceof BaseRailBlock ? ((BaseRailBlock)state.m_60734_()).getRailDirection(state, (BlockGetter)level, offsetPos, null) : RailShape.NORTH_SOUTH;
                if (Helpers.isBlock(state, (TagKey<Block>)BlockTags.f_13034_)) {
                    offset = railshape.m_61745_() ? 0.6 : 0.1;
                } else {
                    if (!state.m_60795_() || !Helpers.isBlock(level.m_8055_(offsetPos.m_7495_()), (TagKey<Block>)BlockTags.f_13034_)) {
                        return this.defaultBehavior.m_6115_(source, stack);
                    }
                    BlockState offsetState = level.m_8055_(offsetPos.m_7495_());
                    RailShape offsetShape = offsetState.m_60734_() instanceof BaseRailBlock ? (RailShape)offsetState.m_61143_(((BaseRailBlock)offsetState.m_60734_()).m_7978_()) : RailShape.NORTH_SOUTH;
                    offset = direction != Direction.DOWN && offsetShape.m_61745_() ? -0.4 : -0.9;
                }
                cartItem.createMinecartEntity((Level)level, stack, x, y + offset, z);
                return stack;
            }
            return ItemStack.f_41583_;
        }

        protected void m_6823_(BlockSource source) {
            source.m_7727_().m_46796_(1000, source.m_7961_(), 0);
        }
    };

    public static void registerDispenserBehaviors() {
        Stream.of(TFCItems.BLUE_STEEL_BUCKET, TFCItems.RED_STEEL_BUCKET, TFCItems.JUG, TFCItems.WOODEN_BUCKET).forEach(reg -> DispenserBlock.m_52672_((ItemLike)((ItemLike)reg.get()), (DispenseItemBehavior)TFC_BUCKET_BEHAVIOR));
        Stream.of(TFCItems.BLUEGILL_BUCKET, TFCItems.COD_BUCKET, TFCItems.JELLYFISH_BUCKET, TFCItems.SALMON_BUCKET, TFCItems.TROPICAL_FISH_BUCKET, TFCItems.PUFFERFISH_BUCKET).forEach(reg -> DispenserBlock.m_52672_((ItemLike)((ItemLike)reg.get()), (DispenseItemBehavior)VANILLA_BUCKET_BEHAVIOR));
        TFCItems.FLUID_BUCKETS.values().forEach(reg -> DispenserBlock.m_52672_((ItemLike)((ItemLike)reg.get()), (DispenseItemBehavior)VANILLA_BUCKET_BEHAVIOR));
        TFCBlocks.WOODS.values().stream().map(map -> (Block)((RegistryObject)map.get((Object)Wood.BlockType.CHEST)).get()).forEach(chest -> DispenserBlock.m_52672_((ItemLike)chest, (DispenseItemBehavior)CHEST_BEHAVIOR));
        TFCItems.CHEST_MINECARTS.values().forEach(reg -> DispenserBlock.m_52672_((ItemLike)((ItemLike)reg.get()), (DispenseItemBehavior)MINECART_BEHAVIOR));
    }
}

