/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.dries007.tfc.common.capabilities.player.PlayerData;
import net.dries007.tfc.common.capabilities.player.PlayerDataCapability;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.ingredients.FluidIngredient;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.FluidDefinition;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class Drinkable
extends FluidDefinition {
    public static final DataManager<Drinkable> MANAGER = new DataManager<Drinkable>(Helpers.identifier("drinkables"), "drinkable", Drinkable::new, Drinkable::new, Drinkable::encode, Packet::new);
    public static final IndirectHashCollection<Fluid, Drinkable> CACHE = IndirectHashCollection.create(FluidDefinition::getFluids, MANAGER::getValues);
    private static final int HAND_DRINK_MB = 25;
    private final float consumeChance;
    private final int thirst;
    private final int intoxication;
    private final List<Effect> effects;
    @Nullable
    private final net.dries007.tfc.common.capabilities.food.FoodData food;

    @Nullable
    public static Drinkable get(Fluid fluid) {
        for (Drinkable drinkable : CACHE.getAll(fluid)) {
            if (!drinkable.matches(fluid)) continue;
            return drinkable;
        }
        return null;
    }

    public static InteractionResult attemptDrink(Level level, Player player, boolean doDrink) {
        BlockHitResult hit = Helpers.rayTracePlayer(level, player, ClipContext.Fluid.SOURCE_ONLY);
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            Drinkable drinkable;
            float f;
            BlockPos pos = hit.m_82425_();
            BlockState state = level.m_8055_(pos);
            Fluid fluid = state.m_60819_().m_76152_();
            FoodData foodData = player.m_36324_();
            if (foodData instanceof TFCFoodData) {
                TFCFoodData data = (TFCFoodData)foodData;
                f = data.getThirst();
            } else {
                f = 100.0f;
            }
            float thirst = f;
            LazyOptional playerData = player.getCapability(PlayerDataCapability.CAPABILITY);
            if (playerData.map(p -> p.getLastDrinkTick() + 10L < Calendars.get((LevelReader)level).getTicks()).orElse(false).booleanValue() && (drinkable = Drinkable.get(fluid)) != null && (thirst < 100.0f || drinkable.getThirst() == 0)) {
                if (!level.f_46443_ && doDrink) {
                    Drinkable.doDrink(level, player, state, pos, (LazyOptional<PlayerData>)playerData, drinkable);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private static void doDrink(Level level, Player player, BlockState state, BlockPos pos, LazyOptional<PlayerData> playerData, Drinkable drinkable) {
        playerData.ifPresent(p -> p.setLastDrinkTick(Calendars.SERVER.getTicks()));
        level.m_5594_(null, pos, SoundEvents.f_11911_, SoundSource.PLAYERS, 1.0f, 1.0f);
        drinkable.onDrink(player, 25);
        if (drinkable.getConsumeChance() > 0.0f && drinkable.getConsumeChance() > level.m_5822_().nextFloat()) {
            BlockState emptyState;
            BlockState blockState = emptyState = FluidHelpers.isAirOrEmptyFluid(state) ? Blocks.f_50016_.m_49966_() : FluidHelpers.fillWithFluid(state, Fluids.f_76191_);
            if (emptyState != null) {
                level.m_7731_(pos, emptyState, 3);
            }
        }
    }

    private Drinkable(ResourceLocation id, JsonObject json) {
        super(id, json);
        this.consumeChance = JsonHelpers.m_13820_((JsonObject)json, (String)"consume_chance", (float)0.0f);
        this.thirst = JsonHelpers.m_13824_((JsonObject)json, (String)"thirst", (int)0);
        this.intoxication = JsonHelpers.m_13824_((JsonObject)json, (String)"intoxication", (int)0);
        this.food = json.has("food") ? net.dries007.tfc.common.capabilities.food.FoodData.read(json.getAsJsonObject("food")) : null;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        if (json.has("effects")) {
            JsonArray array = JsonHelpers.m_13933_((JsonObject)json, (String)"effects");
            for (JsonElement e : array) {
                JsonObject effectJson = JsonHelpers.m_13918_((JsonElement)e, (String)"effect");
                MobEffect type = (MobEffect)JsonHelpers.getRegistryEntry(effectJson, "type", ForgeRegistries.MOB_EFFECTS);
                int duration = JsonHelpers.m_13824_((JsonObject)effectJson, (String)"duration", (int)20);
                int amplifier = JsonHelpers.m_13824_((JsonObject)effectJson, (String)"amplifier", (int)0);
                float chance = (float)JsonHelpers.m_144742_((JsonObject)effectJson, (String)"chance", (double)1.0);
                builder.add((Object)new Effect(type, duration, amplifier, chance));
            }
        }
        this.effects = builder.build();
    }

    private Drinkable(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, FluidIngredient.fromNetwork(buffer));
        this.consumeChance = buffer.readFloat();
        this.thirst = buffer.m_130242_();
        this.intoxication = buffer.m_130242_();
        this.food = Helpers.decodeNullable(buffer, net.dries007.tfc.common.capabilities.food.FoodData::decode);
        this.effects = Helpers.decodeAll(buffer, new ArrayList(), Effect::fromNetwork);
    }

    public void onDrink(Player player, int mB) {
        float multiplier = (float)mB / 25.0f;
        Random random = player.m_21187_();
        FoodData foodData = player.m_36324_();
        if (foodData instanceof TFCFoodData) {
            TFCFoodData foodData2 = (TFCFoodData)foodData;
            foodData2.addThirst((float)this.thirst * multiplier);
        }
        if (this.intoxication > 0) {
            player.getCapability(PlayerDataCapability.CAPABILITY).ifPresent(p -> p.addIntoxicatedTicks((long)((float)this.intoxication * multiplier)));
        }
        if (this.food != null && (foodData = player.m_36324_()) instanceof TFCFoodData) {
            TFCFoodData data = (TFCFoodData)foodData;
            data.eat(this.food);
        }
        for (Effect effect : this.effects) {
            if (!(1.0 - Math.pow(1.0f - effect.chance(), multiplier) > (double)random.nextFloat())) continue;
            player.m_7292_(new MobEffectInstance(effect.type(), effect.duration(), effect.amplifier(), false, false, true));
        }
    }

    public float getConsumeChance() {
        return this.consumeChance;
    }

    public int getThirst() {
        return this.thirst;
    }

    public int getIntoxication() {
        return this.intoxication;
    }

    @Nullable
    public net.dries007.tfc.common.capabilities.food.FoodData getFoodStats() {
        return this.food;
    }

    public Collection<Effect> getEffects() {
        return this.effects;
    }

    private void encode(FriendlyByteBuf buffer) {
        this.ingredient.toNetwork(buffer);
        buffer.writeFloat(this.consumeChance);
        buffer.m_130130_(this.thirst);
        buffer.m_130130_(this.intoxication);
        Helpers.encodeNullable(this.food, buffer, net.dries007.tfc.common.capabilities.food.FoodData::encode);
        Helpers.encodeAll(buffer, this.effects, Effect::toNetwork);
    }

    public record Effect(MobEffect type, int duration, int amplifier, float chance) {
        public static Effect fromNetwork(FriendlyByteBuf buffer) {
            MobEffect type = (MobEffect)buffer.readRegistryIdUnsafe(ForgeRegistries.MOB_EFFECTS);
            int duration = buffer.m_130242_();
            int amplifier = buffer.m_130242_();
            float chance = buffer.readFloat();
            return new Effect(type, duration, amplifier, chance);
        }

        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.MOB_EFFECTS, (IForgeRegistryEntry)this.type);
            buffer.m_130130_(this.duration);
            buffer.m_130130_(this.amplifier);
            buffer.writeFloat(this.chance);
        }
    }

    public static class Packet
    extends DataManagerSyncPacket<Drinkable> {
    }
}

