/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.gson.JsonObject;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.PhysicalDamageType;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public final class EntityDamageResistance
implements PhysicalDamageType.Multiplier {
    public static final DataManager<EntityDamageResistance> MANAGER = new DataManager<EntityDamageResistance>(Helpers.identifier("entity_damage_resistances"), "entity_damage_resistances", EntityDamageResistance::new);
    private final TagKey<EntityType<?>> entity;
    private final float piercing;
    private final float slashing;
    private final float crushing;

    @Nullable
    public static EntityDamageResistance get(Entity entity) {
        for (EntityDamageResistance resist : MANAGER.getValues()) {
            if (!resist.matches(entity)) continue;
            return resist;
        }
        return null;
    }

    private EntityDamageResistance(ResourceLocation id, JsonObject json) {
        this.entity = JsonHelpers.getTag(json, "entity", Registry.f_122903_);
        this.piercing = JsonHelpers.m_13820_((JsonObject)json, (String)"piercing", (float)0.0f);
        this.slashing = JsonHelpers.m_13820_((JsonObject)json, (String)"slashing", (float)0.0f);
        this.crushing = JsonHelpers.m_13820_((JsonObject)json, (String)"crushing", (float)0.0f);
    }

    public boolean matches(Entity entity) {
        return Helpers.isEntity(entity, this.entity);
    }

    @Override
    public float crushing() {
        return this.crushing;
    }

    @Override
    public float piercing() {
        return this.piercing;
    }

    @Override
    public float slashing() {
        return this.slashing;
    }
}

