/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.ItemDefinition;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class Fertilizer
extends ItemDefinition {
    public static final DataManager<Fertilizer> MANAGER = new DataManager<Fertilizer>(Helpers.identifier("fertilizers"), "fertilizer", Fertilizer::new, Fertilizer::new, Fertilizer::encode, Packet::new);
    public static final IndirectHashCollection<Item, Fertilizer> CACHE = IndirectHashCollection.create(ItemDefinition::getValidItems, MANAGER::getValues);
    private final float nitrogen;
    private final float phosphorus;
    private final float potassium;

    @Nullable
    public static Fertilizer get(ItemStack stack) {
        for (Fertilizer def : CACHE.getAll(stack.m_41720_())) {
            if (!def.matches(stack)) continue;
            return def;
        }
        return null;
    }

    private Fertilizer(ResourceLocation id, JsonObject json) {
        super(id, Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "ingredient")));
        this.nitrogen = JsonHelpers.m_13820_((JsonObject)json, (String)"nitrogen", (float)0.0f);
        this.phosphorus = JsonHelpers.m_13820_((JsonObject)json, (String)"phosphorus", (float)0.0f);
        this.potassium = JsonHelpers.m_13820_((JsonObject)json, (String)"potassium", (float)0.0f);
    }

    private Fertilizer(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, Ingredient.m_43940_((FriendlyByteBuf)buffer));
        this.nitrogen = buffer.readFloat();
        this.phosphorus = buffer.readFloat();
        this.potassium = buffer.readFloat();
    }

    public void encode(FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        buffer.writeFloat(this.nitrogen);
        buffer.writeFloat(this.phosphorus);
        buffer.writeFloat(this.potassium);
    }

    public float getNitrogen() {
        return this.nitrogen;
    }

    public float getPhosphorus() {
        return this.phosphorus;
    }

    public float getPotassium() {
        return this.potassium;
    }

    public static class Packet
    extends DataManagerSyncPacket<Fertilizer> {
    }
}

