/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public class KnappingPattern {
    public static final int MAX_WIDTH = 5;
    public static final int MAX_HEIGHT = 5;
    private final int width;
    private final int height;
    private final boolean empty;
    private int data;

    public static KnappingPattern fromJson(JsonObject json) {
        JsonArray array = json.getAsJsonArray("pattern");
        boolean empty = GsonHelper.m_13855_((JsonObject)json, (String)"outside_slot_required", (boolean)true);
        int height = array.size();
        if (height > 5) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 5 is maximum");
        }
        if (height == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        int width = GsonHelper.m_13805_((JsonElement)array.get(0), (String)"pattern[ 0 ]").length();
        if (width > 5) {
            throw new JsonSyntaxException("Invalid pattern: too many columns, 5 is maximum");
        }
        KnappingPattern pattern = new KnappingPattern(width, height, empty);
        for (int r = 0; r < height; ++r) {
            String row = GsonHelper.m_13805_((JsonElement)array.get(r), (String)("pattern[" + r + "]"));
            if (r > 0 && width != row.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            for (int c = 0; c < width; ++c) {
                pattern.set(r * width + c, row.charAt(c) != ' ');
            }
        }
        return pattern;
    }

    public static KnappingPattern fromNetwork(FriendlyByteBuf buffer) {
        int width = buffer.m_130242_();
        int height = buffer.m_130242_();
        int data = buffer.readInt();
        boolean empty = buffer.readBoolean();
        return new KnappingPattern(width, height, data, empty);
    }

    public KnappingPattern() {
        this(5, 5, false);
    }

    public KnappingPattern(int width, int height, boolean empty) {
        this(width, height, (1 << width * height) - 1, empty);
    }

    private KnappingPattern(int width, int height, int data, boolean empty) {
        this.width = width;
        this.height = height;
        this.data = data;
        this.empty = empty;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setAll(boolean value) {
        this.data = value ? (1 << this.width * this.height) - 1 : 0;
    }

    public void set(int x, int y, boolean value) {
        this.set(x + y * this.width, value);
    }

    public void set(int index, boolean value) {
        assert (index >= 0 && index < 32);
        this.data = value ? (this.data |= 1 << index) : (this.data &= ~(1 << index));
    }

    public boolean get(int x, int y) {
        return this.get(x + y * this.width);
    }

    public boolean get(int index) {
        assert (index >= 0 && index < 32);
        return (this.data >> index & 1) == 1;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.width);
        buffer.m_130130_(this.height);
        buffer.writeInt(this.data);
        buffer.writeBoolean(this.empty);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof KnappingPattern) {
            KnappingPattern p = (KnappingPattern)other;
            int mask = (1 << this.width * this.height) - 1;
            return this.width == p.width && this.height == p.height && this.empty == p.empty && (this.data & mask) == (p.data & mask);
        }
        return false;
    }

    public boolean matches(KnappingPattern other) {
        for (int dx = 0; dx <= this.width - other.width; ++dx) {
            for (int dy = 0; dy <= this.height - other.height; ++dy) {
                if (!this.matches(other, dx, dy, false) && !this.matches(other, dx, dy, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(KnappingPattern other, int startX, int startY, boolean mirror) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int patternIdx = y * this.width + x;
                if (x < startX || y < startY || x - startX >= other.width || y - startY >= other.height) {
                    if (this.get(patternIdx) == other.empty) continue;
                    return false;
                }
                int otherIdx = mirror ? (y - startY) * other.width + (other.width - 1 - (x - startX)) : (y - startY) * other.width + (x - startX);
                if (this.get(patternIdx) == other.get(otherIdx)) continue;
                return false;
            }
        }
        return true;
    }
}

