/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.gson.JsonObject;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredients;
import net.dries007.tfc.common.recipes.ingredients.FluidIngredient;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public final class LampFuel {
    public static final DataManager<LampFuel> MANAGER = new DataManager<LampFuel>(Helpers.identifier("lamp_fuels"), "lamp_fuel", LampFuel::new);
    public static final IndirectHashCollection<Fluid, LampFuel> CACHE = IndirectHashCollection.create(s -> s.getFluidIngredient().getMatchingFluids(), MANAGER::getValues);
    private final ResourceLocation id;
    private final FluidIngredient fluidIngredient;
    private final BlockIngredient validLamps;
    private final int burnRate;

    @Nullable
    public static LampFuel get(Fluid fluid, BlockState state) {
        for (LampFuel fuel : CACHE.getAll(fluid)) {
            if (!fuel.matches(fluid, state)) continue;
            return fuel;
        }
        return null;
    }

    public LampFuel(ResourceLocation id, JsonObject json) {
        this.id = id;
        this.fluidIngredient = FluidIngredient.fromJson(JsonHelpers.get(json, "fluid"));
        this.validLamps = BlockIngredients.fromJson(JsonHelpers.get(json, "valid_lamps"));
        this.burnRate = JsonHelpers.m_13927_((JsonObject)json, (String)"burn_rate");
    }

    private boolean matches(Fluid fluid, BlockState state) {
        return this.getFluidIngredient().test(fluid) && this.getValidLamps().test(state);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public int getBurnRate() {
        return this.burnRate;
    }

    public FluidIngredient getFluidIngredient() {
        return this.fluidIngredient;
    }

    public BlockIngredient getValidLamps() {
        return this.validLamps;
    }
}

