/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class PowderKegExplosion
extends Explosion {
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final Entity source;
    private final float size;

    public PowderKegExplosion(Level level, @Nullable Entity entity, double x, double y, double z, float size) {
        super(level, entity, x, y, z, size, false, Explosion.BlockInteraction.NONE);
        this.level = level;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.source = entity;
    }

    public void m_46075_(boolean spawnParticles) {
        if (this.level.f_46443_) {
            this.level.m_7785_(this.x, this.y, this.z, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.f_46441_.nextFloat() - this.level.f_46441_.nextFloat()) * 0.2f) * 0.7f, false);
        }
        if (this.size >= 2.0f) {
            this.level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        } else {
            this.level.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        }
        List affectedBlockPositions = this.m_46081_();
        ObjectArrayList allDrops = new ObjectArrayList();
        Collections.shuffle(affectedBlockPositions, this.level.f_46441_);
        for (BlockPos blockpos : affectedBlockPositions) {
            BlockState blockstate = this.level.m_8055_(blockpos);
            Block block = blockstate.m_60734_();
            if (spawnParticles) {
                double d0 = (float)blockpos.m_123341_() + this.level.f_46441_.nextFloat();
                double d1 = (float)blockpos.m_123342_() + this.level.f_46441_.nextFloat();
                double d2 = (float)blockpos.m_123343_() + this.level.f_46441_.nextFloat();
                double d3 = d0 - this.x;
                double d4 = d1 - this.y;
                double d5 = d2 - this.z;
                double d6 = Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5)));
                d3 /= d6;
                d4 /= d6;
                d5 /= d6;
                double d7 = 0.5 / (d6 / (double)this.size + 0.1);
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, (d0 + this.x) / 2.0, (d1 + this.y) / 2.0, (d2 + this.z) / 2.0, d3 *= (d7 *= (double)(this.level.f_46441_.nextFloat() * this.level.f_46441_.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, d0, d1, d2, d3, d4, d5);
            }
            if (blockstate.m_60795_()) continue;
            BlockPos blockpos1 = blockpos.m_7949_();
            this.level.m_46473_().m_6180_("explosion_blocks");
            if (blockstate.canDropFromExplosion((BlockGetter)this.level, blockpos, (Explosion)this) && this.level instanceof ServerLevel) {
                BlockEntity blockentity = blockstate.m_155947_() ? this.level.m_7702_(blockpos) : null;
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.level).m_78977_(this.level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)blockentity).m_78984_(LootContextParams.f_81455_, (Object)this.source);
                blockstate.m_60724_(lootcontext$builder).forEach(drop -> PowderKegExplosion.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)allDrops, drop, blockpos1));
            }
            blockstate.onBlockExploded(this.level, blockpos, (Explosion)this);
            this.level.m_46473_().m_7238_();
        }
        for (Pair pair : allDrops) {
            Block.m_49840_((Level)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    private static void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> allDrops, ItemStack drop, BlockPos dropPos) {
        int i = allDrops.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)allDrops.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)drop)) continue;
            ItemStack itemstack1 = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)drop, (int)16);
            allDrops.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!drop.m_41619_()) continue;
            return;
        }
        allDrops.add((Object)Pair.of((Object)drop, (Object)dropPos));
    }
}

