/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.DataManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class RegisteredDataManager<T>
extends DataManager<Entry<T>> {
    public static final Logger LOGGER = LogUtils.getLogger();
    protected final BiFunction<ResourceLocation, JsonObject, T> factory;
    protected final Function<ResourceLocation, T> fallbackFactory;
    protected final String typeName;

    @Nullable
    private static <T> BiFunction<ResourceLocation, FriendlyByteBuf, Entry<T>> fixNetworkFactory(@Nullable BiFunction<ResourceLocation, FriendlyByteBuf, T> networkFactory) {
        return networkFactory != null ? networkFactory.andThen(Entry::of) : null;
    }

    @Nullable
    private static <T> BiConsumer<Entry<T>, FriendlyByteBuf> fixNetworkEncoder(@Nullable BiConsumer<T, FriendlyByteBuf> networkEncoder) {
        return networkEncoder != null ? (e, buf) -> networkEncoder.accept(e.value, (FriendlyByteBuf)buf) : null;
    }

    public RegisteredDataManager(BiFunction<ResourceLocation, JsonObject, T> factory, Function<ResourceLocation, T> fallbackFactory, ResourceLocation domain, String typeName) {
        this(factory, fallbackFactory, domain, typeName, null, null, null);
    }

    public RegisteredDataManager(BiFunction<ResourceLocation, JsonObject, T> factory, Function<ResourceLocation, T> fallbackFactory, ResourceLocation domain, String typeName, @Nullable BiFunction<ResourceLocation, FriendlyByteBuf, T> networkFactory, @Nullable BiConsumer<T, FriendlyByteBuf> networkEncoder, @Nullable Supplier<? extends DataManagerSyncPacket<Entry<T>>> networkPacketFactory) {
        super(domain, typeName, (res, id) -> null, RegisteredDataManager.fixNetworkFactory(networkFactory), RegisteredDataManager.fixNetworkEncoder(networkEncoder), networkPacketFactory);
        this.factory = factory;
        this.fallbackFactory = fallbackFactory;
        this.typeName = typeName;
    }

    public synchronized Entry<T> register(ResourceLocation id) {
        return (Entry)this.types.computeIfAbsent((Object)id, key -> new Entry());
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager resourceManager, ProfilerFiller profiler) {
        Entry typeEntry;
        this.types.values().forEach(e -> {
            e.value = null;
        });
        int valid = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : elements.entrySet()) {
            ResourceLocation name = entry.getKey();
            typeEntry = (Entry)this.types.get((Object)name);
            if (typeEntry == null) {
                LOGGER.error("Ignoring {} '{}' as it was not registered.", (Object)this.typeName, (Object)name);
                continue;
            }
            try {
                JsonObject json = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)this.typeName);
                typeEntry.value = this.factory.apply(name, json);
                ++valid;
            }
            catch (JsonParseException | IllegalArgumentException e2) {
                LOGGER.error("{} '{}' failed to parse. {}: {}", new Object[]{this.typeName, name, e2.getClass().getSimpleName(), e2.getMessage()});
            }
        }
        LOGGER.info("Loaded {} / {} {}(s).", new Object[]{valid, this.types.size(), this.typeName});
        for (Map.Entry<Object, Object> entry : this.types.entrySet()) {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            typeEntry = (Entry)entry.getValue();
            if (typeEntry.value != null) continue;
            LOGGER.error("Missing required {} '{}'. Using fallback factory.", (Object)this.typeName, (Object)id);
            typeEntry.value = this.fallbackFactory.apply(id);
        }
    }

    @Override
    public void onSync(NetworkEvent.Context context, Map<ResourceLocation, Entry<T>> elements) {
        if (context.getNetworkManager().m_129531_()) {
            LOGGER.info("Ignored {}(s) sync from logical server", (Object)this.typeName);
        } else {
            for (ResourceLocation id : Sets.union((Set)this.types.keySet(), elements.keySet())) {
                @Nullable Entry type = (Entry)this.types.get((Object)id);
                @Nullable Entry<T> receivedType = elements.get(id);
                if (type == null) {
                    LOGGER.warn("Received an unknown {} from server with id {}", (Object)this.typeName, (Object)id);
                    continue;
                }
                if (receivedType == null) {
                    LOGGER.warn("Missing {} value in sync from server with id {}, using fallback factory", (Object)this.typeName, (Object)id);
                    ((Entry)this.types.get((Object)id)).value = this.fallbackFactory.apply(id);
                    continue;
                }
                type.value = receivedType.value;
            }
            LOGGER.info("Received {} {}(s) from physical server", (Object)this.types.size(), (Object)this.typeName);
        }
    }

    public static class Entry<T>
    implements Supplier<T> {
        @Nullable
        private T value = null;

        private static <T> Entry<T> of(T value) {
            Entry<T> entry = new Entry<T>();
            entry.value = value;
            return entry;
        }

        @Override
        public T get() {
            return Objects.requireNonNull(this.value, "Value requested before data has been loaded");
        }
    }
}

