/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.BodyPlantBlock;
import net.dries007.tfc.common.blocks.plant.Plant;
import net.dries007.tfc.common.blocks.plant.fruit.GrowingFruitTreeBranchBlock;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.common.capabilities.forge.ForgeStep;
import net.dries007.tfc.common.capabilities.forge.ForgingBonus;
import net.dries007.tfc.common.capabilities.heat.Heat;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.capabilities.size.Weight;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.calendar.Day;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.KoppenClimateClassification;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.chunkdata.PlateTectonicsClassification;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.Bootstrap;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;

public final class SelfTests {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean THROW_ON_SELF_TEST_FAIL = true;
    private static boolean EXTERNAL_TAG_LOADING_ERROR = false;

    public static void runWorldVersionTest() {
    }

    public static void runClientSelfTests() {
        if (Helpers.ASSERTIONS_ENABLED) {
            Stopwatch tick = Stopwatch.createStarted();
            SelfTests.throwIfAny(SelfTests.validateOwnBlockEntities(), SelfTests.validateModels(), SelfTests.validateTranslations());
            MinecraftForge.EVENT_BUS.post((Event)new ClientSelfTestEvent());
            LOGGER.info("Client self tests passed in {}", (Object)tick.stop());
        }
    }

    public static void runServerSelfTests() {
        if (Helpers.ASSERTIONS_ENABLED) {
            Stopwatch tick = Stopwatch.createStarted();
            SelfTests.throwIfAny(SelfTests.validateOwnBlockLootTables(), SelfTests.validateOwnBlockMineableTags(), SelfTests.validateOwnWallsTags(), EXTERNAL_TAG_LOADING_ERROR);
            LOGGER.info("Server self tests passed in {}", (Object)tick.stop());
        }
    }

    public static <T extends IForgeRegistryEntry<T>> Stream<T> stream(IForgeRegistry<T> registry, String modID) {
        return registry.getValues().stream().filter(e -> {
            assert (e.getRegistryName() != null);
            return e.getRegistryName().m_135827_().equals(modID);
        });
    }

    public static Function<Block, Stream<BlockState>> states(Predicate<BlockState> filter) {
        return block -> block.m_49965_().m_61056_().stream().filter(filter);
    }

    public static boolean validateBlockEntities(Stream<Block> blocks, Logger logger) {
        ArrayList fbeButNoEbe = new ArrayList();
        ArrayList ebeButNoFbe = new ArrayList();
        ArrayList ebButNoEbe = new ArrayList();
        blocks.forEach(b -> {
            IForgeBlockExtension ex;
            if (b instanceof IForgeBlockExtension && (ex = (IForgeBlockExtension)b).getExtendedProperties().hasBlockEntity() && !(b instanceof EntityBlockExtension)) {
                fbeButNoEbe.add(b);
            }
            if (!(!(b instanceof EntityBlockExtension) || b instanceof IForgeBlockExtension && (ex = (IForgeBlockExtension)b).getExtendedProperties().hasBlockEntity())) {
                ebeButNoFbe.add(b);
            }
            if (b instanceof EntityBlock && !(b instanceof EntityBlockExtension)) {
                ebButNoEbe.add(b);
            }
        });
        return SelfTests.logRegistryErrors("{} blocks found that declare a block entity in IForgeBlockExtension but do not implement EntityBlockExtension", fbeButNoEbe, logger) | SelfTests.logRegistryErrors("{} blocks found that implement EntityBlockExtension but do not declare a block entity in IForgeBlockExtension", ebeButNoFbe, logger) | SelfTests.logRegistryErrors("{} blocks found that implement EntityBlock but do not implement EntityBlockExtension", ebButNoEbe, logger);
    }

    public static <T extends Enum<?>> boolean validateTranslations(Logger logger, Set<String> missingTranslations, Class<? extends T> enumClass) {
        boolean errors = false;
        for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
            errors |= SelfTests.validateTranslation(logger, missingTranslations, (Component)Helpers.translateEnum(enumConstant));
        }
        return errors;
    }

    public static boolean validateTranslation(Logger logger, Set<String> missingTranslations, Component component) {
        if (component instanceof TranslatableComponent) {
            TranslatableComponent translatable = (TranslatableComponent)component;
            if (!Language.m_128107_().m_6722_(translatable.m_131328_())) {
                missingTranslations.add(translatable.m_131328_());
            }
        } else {
            logger.error("Tried to check the translation key of a non-translatable-component, this is almost certainly a bug, {}", (Object)component);
            return true;
        }
        return false;
    }

    public static boolean validateBlockLootTables(Stream<Block> blocks, Logger logger) {
        Set lootTables = ServerLifecycleHooks.getCurrentServer().m_129898_().m_79195_();
        List<Block> missingLootTables = blocks.filter(b -> !lootTables.contains(b.m_60589_())).toList();
        return SelfTests.logRegistryErrors("{} blocks found with a non-existent loot table:", missingLootTables, logger);
    }

    public static boolean validateWallBlockWallsTag(Stream<Block> blocks, Logger logger) {
        List<Block> missingTag = blocks.filter(b -> b instanceof WallBlock && !Helpers.isBlock(b, (TagKey<Block>)BlockTags.f_13032_)).toList();
        return SelfTests.logRegistryErrors("{} wall blocks are missing the #minecraft:walls tag", missingTag, logger);
    }

    public static <T> boolean logErrors(String error, Collection<T> errors, Logger logger) {
        if (!errors.isEmpty()) {
            logger.error(error, (Object)errors.size());
            errors.forEach(e -> logger.error("  {}", e));
            return true;
        }
        return false;
    }

    public static <T extends IForgeRegistryEntry<T>> boolean logRegistryErrors(String error, Collection<T> errors, Logger logger) {
        if (!errors.isEmpty()) {
            logger.error(error, (Object)errors.size());
            errors.forEach(e -> logger.error("  {} of {}", (Object)e.getRegistryName(), (Object)e.getClass().getSimpleName()));
            return true;
        }
        return false;
    }

    public static void throwIfAny(boolean ... errors) {
        for (boolean error : errors) {
            if (error) {
                throw new AssertionError((Object)"Self Tests Failed! Fix the above errors!");
            }
        }
    }

    public static void reportExternalTagLoadingErrors() {
        EXTERNAL_TAG_LOADING_ERROR = true;
    }

    private static boolean validateOwnBlockEntities() {
        List<BlockEntityType> errors = SelfTests.stream(ForgeRegistries.BLOCK_ENTITIES, "tfc").filter(type -> {
            BlockEntity b = type.m_155264_(BlockPos.f_121853_, Blocks.f_50016_.m_49966_());
            return b instanceof TickCounterBlockEntity && b instanceof ICalendarTickable;
        }).toList();
        return SelfTests.logRegistryErrors("{} block entities implement ICalendarTickable through TickCounterBlockEntity, this is almost surely a bug", errors, LOGGER) | SelfTests.validateBlockEntities(SelfTests.stream(ForgeRegistries.BLOCKS, "tfc"), LOGGER);
    }

    private static boolean validateOwnBlockLootTables() {
        Set expectedNoLootTableBlocks = Stream.of(TFCBlocks.PLACED_ITEM, TFCBlocks.PIT_KILN, TFCBlocks.LOG_PILE, TFCBlocks.BURNING_LOG_PILE, TFCBlocks.BLOOM, TFCBlocks.MOLTEN, TFCBlocks.SCRAPING, TFCBlocks.THATCH_BED, TFCBlocks.INGOT_PILE, TFCBlocks.SHEET_PILE, TFCBlocks.PLANTS.get(Plant.GIANT_KELP_PLANT), TFCBlocks.PUMPKIN, TFCBlocks.MELON).map(Supplier::get).collect(Collectors.toSet());
        ImmutableSet expectedNoLootTableClasses = ImmutableSet.of(BodyPlantBlock.class, GrowingFruitTreeBranchBlock.class);
        return SelfTests.validateBlockLootTables(SelfTests.stream(ForgeRegistries.BLOCKS, "tfc").filter(b -> !expectedNoLootTableBlocks.contains(b)).filter(arg_0 -> SelfTests.lambda$validateOwnBlockLootTables$9((Set)expectedNoLootTableClasses, arg_0)), LOGGER);
    }

    private static boolean validateOwnBlockMineableTags() {
        Set expectedNotMineableBlocks = Stream.of(TFCBlocks.PLACED_ITEM, TFCBlocks.PIT_KILN, TFCBlocks.SCRAPING, TFCBlocks.CANDLE, TFCBlocks.DYED_CANDLE.values()).flatMap(Helpers::flatten).map(Supplier::get).collect(Collectors.toSet());
        Set<TagKey<Block>> mineableTags = Set.of(BlockTags.f_144280_, BlockTags.f_144281_, BlockTags.f_144282_, BlockTags.f_144283_, TFCTags.Blocks.MINEABLE_WITH_PROPICK, TFCTags.Blocks.MINEABLE_WITH_HAMMER, TFCTags.Blocks.MINEABLE_WITH_KNIFE, TFCTags.Blocks.MINEABLE_WITH_SCYTHE, TFCTags.Blocks.MINEABLE_WITH_CHISEL);
        List<Block> missingTag = SelfTests.stream(ForgeRegistries.BLOCKS, "tfc").filter(b -> !(b instanceof LiquidBlock) && b.m_155943_() > 0.0f && !expectedNotMineableBlocks.contains(b) && mineableTags.stream().noneMatch(t -> Helpers.isBlock(b, (TagKey<Block>)t))).toList();
        return SelfTests.logRegistryErrors("{} non-fluid blocks have no mineable_with_<tool> tag.", missingTag, LOGGER);
    }

    private static boolean validateOwnWallsTags() {
        return SelfTests.validateWallBlockWallsTag(SelfTests.stream(ForgeRegistries.BLOCKS, "tfc"), LOGGER);
    }

    private static boolean validateModels() {
        BlockModelShaper shaper = Minecraft.m_91087_().m_91289_().m_110907_();
        BakedModel missingModel = shaper.m_110881_().m_119409_();
        TextureAtlasSprite missingParticle = missingModel.m_6160_();
        List<BlockState> missingModelErrors = SelfTests.stream(ForgeRegistries.BLOCKS, "tfc").flatMap(SelfTests.states(s -> s.m_60799_() == RenderShape.MODEL && shaper.m_110893_(s) == missingModel)).toList();
        List<BlockState> missingParticleErrors = SelfTests.stream(ForgeRegistries.BLOCKS, "tfc").flatMap(SelfTests.states(s -> !s.m_60795_() && shaper.m_110882_(s) == missingParticle)).toList();
        return SelfTests.logErrors("{} block states with missing models:", missingModelErrors, LOGGER) | SelfTests.logErrors("{} block states with missing particles:", missingParticleErrors, LOGGER);
    }

    private static boolean validateTranslations() {
        Set missingTranslations = Bootstrap.m_135886_();
        NonNullList items = NonNullList.m_122779_();
        SelfTests.stream(ForgeRegistries.ITEMS, "tfc").forEach(item -> {
            items.clear();
            item.m_6787_(CreativeModeTab.f_40754_, items);
            items.forEach(stack -> SelfTests.validateTranslation(LOGGER, missingTranslations, stack.m_41786_()));
        });
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        ForgeRegistries.SOUND_EVENTS.getKeys().forEach(sound -> Optional.ofNullable(soundManager.m_120384_(sound)).map(WeighedSoundEvents::m_120453_).ifPresent(subtitle -> SelfTests.validateTranslation(LOGGER, missingTranslations, subtitle)));
        boolean error = false;
        for (CreativeModeTab tab : CreativeModeTab.f_40748_) {
            error |= SelfTests.validateTranslation(LOGGER, missingTranslations, tab.m_40786_());
        }
        return (error |= Stream.of(ForgeStep.class, ForgingBonus.class, Metal.Tier.class, Heat.class, Nutrient.class, Size.class, Weight.class, Day.class, Month.class, PlateTectonicsClassification.class, KoppenClimateClassification.class, ForestType.class).anyMatch(clazz -> SelfTests.validateTranslations(LOGGER, missingTranslations, clazz))) | SelfTests.logErrors("{} missing translation keys:", missingTranslations, LOGGER);
    }

    private static /* synthetic */ boolean lambda$validateOwnBlockLootTables$9(Set expectedNoLootTableClasses, Block b) {
        return !expectedNoLootTableClasses.contains(b.getClass());
    }

    public static class ClientSelfTestEvent
    extends Event {
    }
}

