/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import com.mojang.logging.LogUtils;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.calendar.ICalendar;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Calendar
implements ICalendar {
    public static final Logger LOGGER = LogUtils.getLogger();
    protected long playerTicks;
    protected long calendarTicks;
    protected int daysInMonth;
    protected boolean doDaylightCycle;
    protected boolean arePlayersLoggedOn;

    public Calendar() {
        this.resetToDefault();
    }

    @Override
    public long getTicks() {
        return this.playerTicks;
    }

    @Override
    public long getCalendarTicks() {
        return this.calendarTicks;
    }

    @Override
    public int getCalendarDaysInMonth() {
        return this.daysInMonth;
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("daysInMonth", this.daysInMonth);
        nbt.m_128356_("playerTime", this.playerTicks);
        nbt.m_128356_("calendarTime", this.calendarTicks);
        nbt.m_128379_("doDaylightCycle", this.doDaylightCycle);
        nbt.m_128379_("arePlayersLoggedOn", this.arePlayersLoggedOn);
        return nbt;
    }

    public void read(@Nullable CompoundTag nbt) {
        if (nbt != null) {
            this.daysInMonth = nbt.m_128451_("daysInMonth");
            this.playerTicks = nbt.m_128454_("playerTime");
            this.calendarTicks = nbt.m_128454_("calendarTime");
            this.doDaylightCycle = nbt.m_128471_("doDaylightCycle");
            this.arePlayersLoggedOn = nbt.m_128471_("arePlayersLoggedOn");
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.daysInMonth);
        buffer.m_130103_(this.playerTicks);
        buffer.m_130103_(this.calendarTicks);
        buffer.writeBoolean(this.doDaylightCycle);
        buffer.writeBoolean(this.arePlayersLoggedOn);
    }

    public void read(FriendlyByteBuf buffer) {
        this.daysInMonth = buffer.m_130242_();
        this.playerTicks = buffer.m_130258_();
        this.calendarTicks = buffer.m_130258_();
        this.doDaylightCycle = buffer.readBoolean();
        this.arePlayersLoggedOn = buffer.readBoolean();
    }

    public void resetTo(Calendar resetTo) {
        this.daysInMonth = resetTo.daysInMonth;
        this.playerTicks = resetTo.playerTicks;
        this.calendarTicks = resetTo.calendarTicks;
        this.doDaylightCycle = resetTo.doDaylightCycle;
        this.arePlayersLoggedOn = resetTo.arePlayersLoggedOn;
    }

    public void resetToDefault() {
        this.daysInMonth = (Integer)TFCConfig.COMMON.defaultMonthLength.get();
        this.playerTicks = 0L;
        this.calendarTicks = (long)((Integer)TFCConfig.COMMON.defaultCalendarStartDay.get()).intValue() * 24000L + 6000L;
        this.doDaylightCycle = true;
        this.arePlayersLoggedOn = false;
    }
}

