/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import net.dries007.tfc.mixin.accessor.GameRulesAccessor;
import net.dries007.tfc.mixin.accessor.GameRulesTypeAccessor;
import net.dries007.tfc.network.CalendarUpdatePacket;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.util.ReentrantRunnable;
import net.dries007.tfc.util.calendar.Calendar;
import net.dries007.tfc.util.calendar.CalendarWorldData;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ServerCalendar
extends Calendar {
    public static final int SYNC_INTERVAL = 20;
    public static final int TIME_DESYNC_THRESHOLD = 5;
    private static final ReentrantRunnable DO_DAYLIGHT_CYCLE = new ReentrantRunnable(() -> Calendars.SERVER.setDoDaylightCycle());
    private int syncCounter;

    public static void overrideDoDaylightCycleCallback() {
        GameRulesTypeAccessor type = (GameRulesTypeAccessor)GameRulesAccessor.accessor$getGameRuleTypes().get(GameRules.f_46140_);
        type.accessor$setCallback(type.accessor$getCallback().andThen((server, t) -> DO_DAYLIGHT_CYCLE.run()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTransaction(long transactionPlayerTimeOffset, long transactionCalendarTimeOffset, Runnable transaction) {
        try {
            this.playerTicks += transactionPlayerTimeOffset;
            this.calendarTicks += transactionCalendarTimeOffset;
            transaction.run();
        }
        finally {
            this.playerTicks -= transactionPlayerTimeOffset;
            this.calendarTicks -= transactionCalendarTimeOffset;
        }
    }

    public void setTimeFromCalendarTime(long calendarTimeToSetTo) {
        long timeJump = calendarTimeToSetTo - this.calendarTicks;
        this.calendarTicks = calendarTimeToSetTo;
        this.playerTicks += timeJump;
        for (ServerLevel world : this.getServer().m_129785_()) {
            long currentDayTime = world.m_46468_();
            world.m_8615_(currentDayTime + timeJump);
        }
        this.sendUpdatePacket();
    }

    public long setTimeFromDayTime(long worldTimeToSetTo) {
        long worldTimeJump = worldTimeToSetTo % 24000L - this.getCalendarDayTime();
        if (worldTimeJump < 0L) {
            worldTimeJump += 24000L;
        }
        this.calendarTicks += worldTimeJump;
        this.playerTicks += worldTimeJump;
        return worldTimeJump;
    }

    public void setMonthLength(int newMonthLength) {
        long baseMonths = this.getTotalCalendarMonths();
        long baseDayTime = this.calendarTicks - this.getTotalCalendarDays() * 24000L;
        float monthPercent = (float)(this.getCalendarDayOfMonth() - 1) / (float)this.daysInMonth;
        int newDayOfMonth = (int)(monthPercent * (float)newMonthLength);
        this.daysInMonth = newMonthLength;
        this.calendarTicks = (baseMonths * (long)this.daysInMonth + (long)newDayOfMonth) * 24000L + baseDayTime;
        this.sendUpdatePacket();
    }

    public void setPlayersLoggedOn(boolean arePlayersLoggedOn) {
        GameRules rules = this.getServer().m_129783_().m_46469_();
        this.arePlayersLoggedOn = arePlayersLoggedOn;
        if (arePlayersLoggedOn) {
            DO_DAYLIGHT_CYCLE.runBlocking(() -> ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46140_)).m_46246_(this.doDaylightCycle, this.getServer()));
            LOGGER.info("Reverted doDaylightCycle to {} as players are logged in.", (Object)this.doDaylightCycle);
        } else {
            DO_DAYLIGHT_CYCLE.runBlocking(() -> ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46140_)).m_46246_(false, this.getServer()));
            LOGGER.info("Forced doDaylightCycle to false as no players are logged in. Will revert to {} as soon as a player logs in.", (Object)this.doDaylightCycle);
        }
        this.sendUpdatePacket();
    }

    public void setDoDaylightCycle() {
        GameRules rules = this.getServer().m_129900_();
        this.doDaylightCycle = rules.m_46207_(GameRules.f_46140_);
        if (!this.arePlayersLoggedOn) {
            DO_DAYLIGHT_CYCLE.runBlocking(() -> ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46140_)).m_46246_(false, this.getServer()));
            LOGGER.info("Forced doDaylightCycle to false as no players are logged in. Will revert to {} as soon as a player logs in.", (Object)this.doDaylightCycle);
        }
        this.sendUpdatePacket();
    }

    void onServerStart(MinecraftServer server) {
        GameRules rules = server.m_129783_().m_46469_();
        DO_DAYLIGHT_CYCLE.runBlocking(() -> ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46140_)).m_46246_(false, server));
        this.resetTo(CalendarWorldData.get(server.m_129783_()).getCalendar());
        this.sendUpdatePacket();
    }

    void onServerStop() {
        this.resetToDefault();
    }

    void onServerTick() {
        if (this.arePlayersLoggedOn) {
            ++this.playerTicks;
        }
        ++this.syncCounter;
        if (this.syncCounter >= 20) {
            this.sendUpdatePacket();
            this.syncCounter = 0;
        }
    }

    void onOverworldTick(ServerLevel world) {
        long deltaWorldTime;
        if (this.doDaylightCycle && this.arePlayersLoggedOn) {
            ++this.calendarTicks;
        }
        if ((deltaWorldTime = world.m_46468_() % 24000L - this.getCalendarDayTime()) > 5L || deltaWorldTime < -5L) {
            boolean checkArePlayersLoggedOn;
            LOGGER.warn("World time and Calendar Time are out of sync! Trying to fix...");
            LOGGER.debug("Calendar Time = {} ({}), Player Time = {}, World Time = {}, doDaylightCycle = {}, ArePlayersLoggedOn = {}", new Object[]{this.calendarTicks, this.getCalendarDayTime(), this.playerTicks, world.m_46468_() % 24000L, this.doDaylightCycle, this.arePlayersLoggedOn});
            boolean bl = checkArePlayersLoggedOn = this.getServer().m_6846_().m_11309_() > 0;
            if (this.arePlayersLoggedOn != checkArePlayersLoggedOn) {
                LOGGER.info("Setting ArePlayersLoggedOn = {}", (Object)checkArePlayersLoggedOn);
                this.setPlayersLoggedOn(checkArePlayersLoggedOn);
            }
            if (this.arePlayersLoggedOn && this.doDaylightCycle != this.getServer().m_129900_().m_46207_(GameRules.f_46140_)) {
                LOGGER.info("Setting DoDaylightCycle = {}", (Object)this.getServer().m_129900_().m_46207_(GameRules.f_46140_));
                this.setDoDaylightCycle();
            }
            if (deltaWorldTime < 0L) {
                world.m_8615_(world.m_46468_() - deltaWorldTime);
                LOGGER.info("Calendar is ahead by {} ticks, jumping world time to catch up", (Object)(-deltaWorldTime));
            } else {
                this.calendarTicks += deltaWorldTime;
                LOGGER.info("Calendar is behind by {} ticks, jumping calendar time to catch up", (Object)deltaWorldTime);
            }
            this.sendUpdatePacket();
        }
    }

    void sendUpdatePacket() {
        PacketHandler.send(PacketDistributor.ALL.noArg(), new CalendarUpdatePacket(this));
    }

    private MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }
}

