/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.events;

import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

@Cancelable
public final class AnimalProductEvent
extends Event {
    private final Level level;
    private final BlockPos pos;
    private final TFCAnimalProperties animalProperties;
    @Nullable
    private final Player player;
    private final ItemStack tool;
    private ItemStack product;
    private int uses;

    public static boolean produce(Level level, BlockPos pos, TFCAnimalProperties entity, ItemStack product, ItemStack tool, int uses) {
        return AnimalProductEvent.produce(level, pos, null, entity, product, tool, uses);
    }

    public static boolean produce(Level level, BlockPos pos, @Nullable Player player, TFCAnimalProperties entity, ItemStack product, ItemStack tool, int uses) {
        AnimalProductEvent event = new AnimalProductEvent(level, pos, player, entity, product, tool, uses);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            if (!level.f_46443_) {
                if (player != null) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)event.getProduct());
                } else {
                    Helpers.spawnItem(level, pos, event.getProduct());
                }
            }
            entity.addUses(event.getUses());
            return true;
        }
        return false;
    }

    public AnimalProductEvent(Level level, BlockPos pos, @Nullable Player player, TFCAnimalProperties entity, ItemStack product, ItemStack tool, int uses) {
        this.level = level;
        this.pos = pos;
        this.animalProperties = entity;
        this.player = player;
        this.tool = tool;
        this.product = product;
        this.uses = uses;
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public TFCAnimalProperties getAnimalProperties() {
        return this.animalProperties;
    }

    public Entity getEntity() {
        return this.getAnimalProperties().getEntity();
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public ItemStack getTool() {
        return this.tool;
    }

    public ItemStack getProduct() {
        return this.product;
    }

    public void setProduct(ItemStack product) {
        this.product = product;
    }

    public int getUses() {
        return this.uses;
    }

    public void setUses(int uses) {
        this.uses = uses;
    }
}

