/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.events;

import java.util.function.Predicate;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

@Cancelable
public final class StartFireEvent
extends Event {
    private final Level world;
    private final BlockPos pos;
    private final BlockState state;
    private final Direction direction;
    @Nullable
    private final Player player;
    private final ItemStack stack;
    private FireResult fireResult;

    public static boolean startFire(Level level, BlockPos pos, BlockState state, Direction direction, @Nullable Player player, ItemStack stack) {
        return StartFireEvent.startFire(level, pos, state, direction, player, stack, FireResult.IF_FAILED);
    }

    public static boolean startFire(Level level, BlockPos pos, BlockState state, Direction direction, @Nullable Player player, ItemStack stack, FireResult fireResult) {
        StartFireEvent event = new StartFireEvent(level, pos, state, direction, player, stack, fireResult);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        boolean actionPerformed = false;
        if (cancelled) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                TFCAdvancements.LIT.trigger(serverPlayer, state);
            }
            actionPerformed = true;
        }
        if (event.fireResult.predicate.test(event) && BaseFireBlock.m_49255_((Level)level, (BlockPos)(pos = pos.m_142300_(direction)), (Direction)direction)) {
            level.m_7731_(pos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)pos), 11);
            actionPerformed = true;
        }
        return actionPerformed;
    }

    private StartFireEvent(Level world, BlockPos pos, BlockState state, Direction direction, @Nullable Player player, ItemStack stack, FireResult result) {
        this.world = world;
        this.pos = pos;
        this.state = state;
        this.direction = direction;
        this.player = player;
        this.stack = stack;
        this.fireResult = result;
    }

    public Level getLevel() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockState getState() {
        return this.state;
    }

    public Direction getTargetedFace() {
        return this.direction;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public FireResult getFireResult() {
        return this.fireResult;
    }

    public void setFireResult(FireResult result) {
        this.fireResult = result;
    }

    public static enum FireResult {
        ALWAYS(event -> true),
        NEVER(event -> false),
        IF_FAILED(event -> !event.isCanceled());

        private final Predicate<StartFireEvent> predicate;

        private FireResult(Predicate<StartFireEvent> predicate) {
            this.predicate = predicate;
        }
    }
}

