/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.loot;

import java.util.function.Supplier;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.loot.AlwaysTrueCondition;
import net.dries007.tfc.util.loot.CopyFluidFunction;
import net.dries007.tfc.util.loot.CropYieldProvider;
import net.dries007.tfc.util.loot.IsIsolatedCondition;
import net.dries007.tfc.util.loot.PannedCondition;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class TFCLoot {
    public static final DeferredRegister<LootItemConditionType> CONDITIONS = DeferredRegister.create((ResourceKey)Registry.f_122817_, (String)"tfc");
    public static final DeferredRegister<LootNumberProviderType> NUMBER_PROVIDERS = DeferredRegister.create((ResourceKey)Registry.f_175409_, (String)"tfc");
    public static final DeferredRegister<LootItemFunctionType> LOOT_FUNCTIONS = DeferredRegister.create((ResourceKey)Registry.f_122816_, (String)"tfc");
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> LOOT_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.LOOT_MODIFIER_SERIALIZERS, (String)"tfc");
    public static final LootContextParam<Boolean> ISOLATED = new LootContextParam(Helpers.identifier("isolated"));
    public static final LootContextParam<Boolean> PANNED = new LootContextParam(Helpers.identifier("panned"));
    public static final RegistryObject<LootItemConditionType> IS_PANNED = TFCLoot.lootCondition("is_panned", new PannedCondition.Serializer());
    public static final RegistryObject<LootItemConditionType> IS_ISOLATED = TFCLoot.lootCondition("is_isolated", new IsIsolatedCondition.Serializer());
    public static final RegistryObject<LootItemConditionType> ALWAYS_TRUE = TFCLoot.lootCondition("always_true", new AlwaysTrueCondition.Serializer());
    public static final RegistryObject<LootNumberProviderType> CROP_YIELD = TFCLoot.numberProvider("crop_yield_uniform", new CropYieldProvider.Serializer());
    public static final RegistryObject<LootItemFunctionType> COPY_FLUID = TFCLoot.lootFunction("copy_fluid", (Serializer<? extends LootItemFunction>)new CopyFluidFunction.Serializer());

    private static RegistryObject<LootItemFunctionType> lootFunction(String id, Serializer<? extends LootItemFunction> serializer) {
        return LOOT_FUNCTIONS.register(id, () -> new LootItemFunctionType(serializer));
    }

    private static RegistryObject<LootItemConditionType> lootCondition(String id, Serializer<? extends LootItemCondition> serializer) {
        return CONDITIONS.register(id, () -> new LootItemConditionType(serializer));
    }

    private static RegistryObject<LootNumberProviderType> numberProvider(String id, Serializer<? extends NumberProvider> serializer) {
        return NUMBER_PROVIDERS.register(id, () -> new LootNumberProviderType(serializer));
    }

    private static <T extends GlobalLootModifierSerializer<? extends IGlobalLootModifier>> RegistryObject<T> glmSerializer(String id, Supplier<T> modifier) {
        return LOOT_MODIFIER_SERIALIZERS.register(id, modifier);
    }

    public static void registerAll(IEventBus bus) {
        CONDITIONS.register(bus);
        NUMBER_PROVIDERS.register(bus);
        LOOT_FUNCTIONS.register(bus);
        LOOT_MODIFIER_SERIALIZERS.register(bus);
    }
}

