/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.registry;

import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.ItemStackContainer;
import net.dries007.tfc.common.container.ItemStackContainerProvider;
import net.dries007.tfc.common.fluids.FlowingFluidRegistryObject;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public final class RegistrationHelpers {
    public static <T extends Block> RegistryObject<T> registerBlock(DeferredRegister<Block> blocks, DeferredRegister<Item> items, String name, Supplier<T> blockSupplier, @Nullable Function<T, ? extends BlockItem> blockItemFactory) {
        String actualName = name.toLowerCase(Locale.ROOT);
        RegistryObject block = blocks.register(actualName, blockSupplier);
        if (blockItemFactory != null) {
            items.register(actualName, () -> (BlockItem)blockItemFactory.apply((Block)block.get()));
        }
        return block;
    }

    public static FlowingFluidRegistryObject<ForgeFlowingFluid> registerFluid(DeferredRegister<Fluid> fluids, String sourceName, String flowingName, Consumer<ForgeFlowingFluid.Properties> builder, FluidAttributes.Builder attributes) {
        return RegistrationHelpers.registerFluid(fluids, sourceName, flowingName, builder, attributes, ForgeFlowingFluid.Source::new, ForgeFlowingFluid.Flowing::new);
    }

    public static <F extends FlowingFluid> FlowingFluidRegistryObject<F> registerFluid(DeferredRegister<Fluid> fluids, String sourceName, String flowingName, Consumer<ForgeFlowingFluid.Properties> builder, FluidAttributes.Builder attributes, Function<ForgeFlowingFluid.Properties, F> sourceFactory, Function<ForgeFlowingFluid.Properties, F> flowingFactory) {
        MutableObject propertiesBox = new MutableObject();
        RegistryObject source = fluids.register(sourceName, () -> RegistrationHelpers.lambda$registerFluid$1(sourceFactory, (Mutable)propertiesBox));
        RegistryObject flowing = fluids.register(flowingName, () -> RegistrationHelpers.lambda$registerFluid$2(flowingFactory, (Mutable)propertiesBox));
        propertiesBox.setValue((Object)Lazy.of(() -> {
            ForgeFlowingFluid.Properties lazyProperties = new ForgeFlowingFluid.Properties((Supplier)source, (Supplier)flowing, attributes);
            builder.accept(lazyProperties);
            return lazyProperties;
        }));
        return new FlowingFluidRegistryObject(flowing, source);
    }

    public static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> register(DeferredRegister<BlockEntityType<?>> blockEntities, String name, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<? extends Block> block) {
        return blockEntities.register(name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)factory, (Block[])new Block[]{(Block)block.get()}).m_58966_(null));
    }

    public static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> register(DeferredRegister<BlockEntityType<?>> blockEntities, String name, BlockEntityType.BlockEntitySupplier<T> factory, Stream<? extends Supplier<? extends Block>> blocks) {
        return blockEntities.register(name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)factory, (Block[])((Block[])blocks.map(Supplier::get).toArray(Block[]::new))).m_58966_(null));
    }

    public static <T extends InventoryBlockEntity<?>, C extends BlockEntityContainer<T>> RegistryObject<MenuType<C>> registerBlockEntityContainer(DeferredRegister<MenuType<?>> containers, String name, Supplier<BlockEntityType<T>> type, BlockEntityContainer.Factory<T, C> factory) {
        return RegistrationHelpers.registerContainer(containers, name, (windowId, playerInventory, buffer) -> {
            Level world = playerInventory.f_35978_.f_19853_;
            BlockPos pos = buffer.m_130135_();
            InventoryBlockEntity entity = (InventoryBlockEntity)world.m_141902_(pos, (BlockEntityType)type.get()).orElseThrow();
            return factory.create(entity, playerInventory, windowId);
        });
    }

    public static <C extends ItemStackContainer> RegistryObject<MenuType<C>> registerItemStackContainer(DeferredRegister<MenuType<?>> containers, String name, ItemStackContainer.Factory<C> factory) {
        return RegistrationHelpers.registerContainer(containers, name, (windowId, playerInventory, buffer) -> {
            InteractionHand hand = ItemStackContainerProvider.read(buffer);
            ItemStack stack = playerInventory.f_35978_.m_21120_(hand);
            return factory.create(stack, hand, playerInventory, windowId);
        });
    }

    public static <C extends AbstractContainerMenu> RegistryObject<MenuType<C>> registerContainer(DeferredRegister<MenuType<?>> containers, String name, IContainerFactory<C> factory) {
        return containers.register(name, () -> IForgeMenuType.create((IContainerFactory)factory));
    }

    private static /* synthetic */ FlowingFluid lambda$registerFluid$2(Function flowingFactory, Mutable propertiesBox) {
        return (FlowingFluid)flowingFactory.apply((ForgeFlowingFluid.Properties)((Lazy)propertiesBox.getValue()).get());
    }

    private static /* synthetic */ FlowingFluid lambda$registerFluid$1(Function sourceFactory, Mutable propertiesBox) {
        return (FlowingFluid)sourceFactory.apply((ForgeFlowingFluid.Properties)((Lazy)propertiesBox.getValue()).get());
    }
}

