/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.tracker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.TFCFallingBlockEntity;
import net.dries007.tfc.common.recipes.CollapseRecipe;
import net.dries007.tfc.common.recipes.LandslideRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.network.RainfallUpdatePacket;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.BiomeBasedClimateModel;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.collections.BufferedList;
import net.dries007.tfc.util.loot.TFCLoot;
import net.dries007.tfc.util.tracker.Collapse;
import net.dries007.tfc.util.tracker.TickEntry;
import net.dries007.tfc.util.tracker.WorldTrackerCapability;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldTracker
implements ICapabilitySerializable<CompoundTag> {
    private final Level level;
    private final Random random;
    private final LazyOptional<WorldTracker> capability;
    private final BufferedList<TickEntry> landslideTicks;
    private final BufferedList<BlockPos> isolatedPositions;
    private final List<Collapse> collapsesInProgress;
    private final ClimateModel defaultClimateModel = new BiomeBasedClimateModel();
    @Nullable
    private ClimateModel climateModel;
    private long rainStartTick;
    private long rainEndTick;
    private float rainIntensity;

    public WorldTracker(Level level) {
        this.level = level;
        this.random = new Random();
        this.capability = LazyOptional.of(() -> this);
        this.climateModel = null;
        this.landslideTicks = new BufferedList();
        this.isolatedPositions = new BufferedList();
        this.collapsesInProgress = new ArrayList<Collapse>();
    }

    public void addLandslidePos(BlockPos pos) {
        this.landslideTicks.add(new TickEntry(pos, 2));
    }

    public void addIsolatedPos(BlockPos pos) {
        this.isolatedPositions.add(pos);
    }

    public void addCollapseData(Collapse collapse) {
        this.collapsesInProgress.add(collapse);
    }

    public void setClimateModel(ClimateModel climateModel) {
        this.climateModel = climateModel;
    }

    public ClimateModel getClimateModel() {
        return this.climateModel == null ? this.defaultClimateModel : this.climateModel;
    }

    public void addCollapsePositions(BlockPos centerPos, Collection<BlockPos> positions) {
        ArrayList<BlockPos> collapsePositions = new ArrayList<BlockPos>();
        double maxRadiusSquared = 0.0;
        for (BlockPos pos : positions) {
            double distSquared = pos.m_123331_((Vec3i)centerPos);
            if (distSquared > maxRadiusSquared) {
                maxRadiusSquared = distSquared;
            }
            if (!((double)this.random.nextFloat() < (Double)TFCConfig.SERVER.collapseExplosionPropagateChance.get())) continue;
            collapsePositions.add(pos.m_7494_());
        }
        this.addCollapseData(new Collapse(centerPos, collapsePositions, maxRadiusSquared));
    }

    public void setWeatherData(long rainDuration, float rainIntensity) {
        long tick = Calendars.get((LevelReader)this.level).getTicks();
        this.setWeatherData(tick, tick + rainDuration, rainIntensity);
    }

    public void setWeatherData(long rainStartTick, long rainEndTick, float rainIntensity) {
        this.rainStartTick = rainStartTick;
        this.rainEndTick = rainEndTick;
        this.rainIntensity = rainIntensity;
        this.sync();
    }

    public boolean isRaining(Level level, BlockPos pos) {
        return this.isRaining(Calendars.get((LevelReader)level).getTicks(), Climate.getRainfall(level, pos));
    }

    public boolean isRaining(long tick, float rainfall) {
        return this.exactRainfallIntensity(tick) > Mth.m_184631_((float)rainfall, (float)0.0f, (float)500.0f, (float)1.0f, (float)0.0f);
    }

    public void tick(ServerLevel level) {
        if (!this.collapsesInProgress.isEmpty() && this.random.nextInt(10) == 0) {
            for (Collapse collapse2 : this.collapsesInProgress) {
                HashSet<BlockPos> updatedPositions = new HashSet<BlockPos>();
                for (BlockPos posAt : collapse2.nextPositions) {
                    BlockState stateAt = level.m_8055_(posAt);
                    if (!Helpers.isBlock(stateAt, TFCTags.Blocks.CAN_COLLAPSE) || !TFCFallingBlockEntity.canFallInDirection((BlockGetter)level, posAt, Direction.DOWN) || !(posAt.m_123331_((Vec3i)collapse2.centerPos) < collapse2.radiusSquared) || !((double)this.random.nextFloat() < (Double)TFCConfig.SERVER.collapsePropagateChance.get()) || !CollapseRecipe.collapseBlock((Level)level, posAt, stateAt)) continue;
                    updatedPositions.add(posAt.m_7494_());
                }
                collapse2.nextPositions.clear();
                if (updatedPositions.isEmpty()) continue;
                level.m_5594_(null, collapse2.centerPos, (SoundEvent)TFCSounds.ROCK_SLIDE_SHORT.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
                collapse2.nextPositions.addAll(updatedPositions);
                collapse2.radiusSquared *= 0.8;
            }
            this.collapsesInProgress.removeIf(collapse -> collapse.nextPositions.isEmpty());
        }
        this.landslideTicks.flush();
        ListIterator tickIterator = this.landslideTicks.listIterator();
        while (tickIterator.hasNext()) {
            TickEntry entry = (TickEntry)tickIterator.next();
            if (!entry.tick()) continue;
            BlockState currentState = level.m_8055_(entry.getPos());
            LandslideRecipe.tryLandslide((Level)level, entry.getPos(), currentState);
            tickIterator.remove();
        }
        this.isolatedPositions.flush();
        ListIterator isolatedIterator = this.isolatedPositions.listIterator();
        while (isolatedIterator.hasNext()) {
            BlockPos pos = (BlockPos)isolatedIterator.next();
            BlockState currentState = level.m_8055_(pos);
            if (Helpers.isBlock(currentState.m_60734_(), TFCTags.Blocks.BREAKS_WHEN_ISOLATED) && this.isIsolated((LevelAccessor)level, pos)) {
                Helpers.destroyBlockAndDropBlocksManually(level, pos, ctx -> ctx.m_78972_(TFCLoot.ISOLATED, (Object)true));
            }
            isolatedIterator.remove();
        }
    }

    public void addDebugTooltip(List<String> tooltips) {
        tooltips.add("R [%d, %d] I (%.2f) %.2f".formatted(this.rainStartTick, this.rainEndTick, Float.valueOf(this.rainIntensity), Float.valueOf(this.exactRainfallIntensity(Calendars.CLIENT.getTicks()))));
    }

    public void sync() {
        if (!this.level.m_5776_()) {
            PacketHandler.send(PacketDistributor.DIMENSION.with(() -> ((Level)this.level).m_46472_()), new RainfallUpdatePacket(this.rainStartTick, this.rainEndTick, this.rainIntensity));
        }
    }

    public void syncTo(ServerPlayer player) {
        PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new RainfallUpdatePacket(this.rainStartTick, this.rainEndTick, this.rainIntensity));
    }

    public CompoundTag serializeNBT() {
        this.landslideTicks.flush();
        this.isolatedPositions.flush();
        CompoundTag nbt = new CompoundTag();
        ListTag landslideNbt = new ListTag();
        for (TickEntry entry : this.landslideTicks) {
            landslideNbt.add((Object)entry.serializeNBT());
        }
        nbt.m_128365_("landslideTicks", (Tag)landslideNbt);
        LongArrayTag isolatedNbt = new LongArrayTag(this.isolatedPositions.stream().mapToLong(BlockPos::m_121878_).toArray());
        nbt.m_128365_("isolatedPositions", (Tag)isolatedNbt);
        ListTag collapseNbt = new ListTag();
        for (Collapse collapse : this.collapsesInProgress) {
            collapseNbt.add((Object)collapse.serializeNBT());
        }
        nbt.m_128365_("collapsesInProgress", (Tag)collapseNbt);
        nbt.m_128356_("rainStartTick", this.rainStartTick);
        nbt.m_128356_("rainEndTick", this.rainEndTick);
        nbt.m_128350_("rainIntensity", this.rainIntensity);
        return nbt;
    }

    public void deserializeNBT(@Nullable CompoundTag nbt) {
        if (nbt != null) {
            this.landslideTicks.clear();
            this.collapsesInProgress.clear();
            this.isolatedPositions.clear();
            ListTag landslideNbt = nbt.m_128437_("landslideTicks", 10);
            for (int i = 0; i < landslideNbt.size(); ++i) {
                this.landslideTicks.add(new TickEntry(landslideNbt.m_128728_(i)));
            }
            long[] isolatedNbt = nbt.m_128467_("isolatedPositions");
            Arrays.stream(isolatedNbt).mapToObj(BlockPos::m_122022_).forEach(this.isolatedPositions::add);
            ListTag collapseNbt = nbt.m_128437_("collapsesInProgress", 10);
            for (int i = 0; i < collapseNbt.size(); ++i) {
                this.collapsesInProgress.add(new Collapse(collapseNbt.m_128728_(i)));
            }
            this.rainStartTick = nbt.m_128454_("rainStartTick");
            this.rainEndTick = nbt.m_128454_("rainEndTick");
            this.rainIntensity = nbt.m_128457_("rainIntensity");
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return WorldTrackerCapability.CAPABILITY.orEmpty(cap, this.capability);
    }

    private float exactRainfallIntensity(long tick) {
        float progress = Mth.m_14036_((float)Helpers.inverseLerp(tick, this.rainStartTick, this.rainEndTick), (float)0.0f, (float)1.0f);
        float progressFactor = progress > 0.5f ? 1.0f - progress : progress;
        return this.rainIntensity * 0.5f + progressFactor;
    }

    private boolean isIsolated(LevelAccessor level, BlockPos pos) {
        for (Direction direction : Helpers.DIRECTIONS) {
            BlockState state = level.m_8055_(pos.m_142300_(direction));
            if (state.m_60812_((BlockGetter)level, pos).m_83281_()) continue;
            return false;
        }
        return true;
    }
}

