/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.dries007.tfc.util.IArtist;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeSourceExtension;
import net.dries007.tfc.world.biome.RiverSource;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.chunkdata.TFCChunkDataGenerator;
import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.layer.framework.ConcurrentArea;
import net.dries007.tfc.world.river.Flow;
import net.dries007.tfc.world.river.MidpointFractal;
import net.dries007.tfc.world.river.Watershed;
import net.dries007.tfc.world.settings.ClimateSettings;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraftforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class TFCBiomeSource
extends BiomeSource
implements BiomeSourceExtension,
RiverSource {
    public static final Codec<TFCBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.optionalFieldOf("seed", (Object)0L).forGetter(c -> c.seed), (App)Codec.INT.fieldOf("spawn_distance").forGetter(TFCBiomeSource::getSpawnDistance), (App)Codec.INT.fieldOf("spawn_center_x").forGetter(c -> c.spawnCenterX), (App)Codec.INT.fieldOf("spawn_center_z").forGetter(c -> c.spawnCenterZ), (App)RockLayerSettings.CODEC.fieldOf("rock_layer_settings").forGetter(c -> c.rockLayerSettings), (App)ClimateSettings.CODEC.fieldOf("temperature_settings").forGetter(c -> c.temperatureSettings), (App)ClimateSettings.CODEC.fieldOf("rainfall_settings").forGetter(c -> c.rainfallSettings), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(c -> c.biomeRegistry)).apply((Applicative)instance, TFCBiomeSource::new));
    public static final DeferredRegister<Codec<? extends BiomeSource>> BIOME_SOURCE = DeferredRegister.create((ResourceKey)Registry.f_122852_, (String)"tfc");
    private final long seed;
    private final int spawnDistance;
    private final int spawnCenterX;
    private final int spawnCenterZ;
    private final RockLayerSettings rockLayerSettings;
    private final ClimateSettings temperatureSettings;
    private final ClimateSettings rainfallSettings;
    private final Registry<Biome> biomeRegistry;
    private final ConcurrentArea<BiomeExtension> biomeLayer;
    private final ChunkDataProvider chunkDataProvider;
    private final Watershed.Context watersheds;

    public static TFCBiomeSource defaultBiomeSource(long seed, Registry<Biome> biomeRegistry) {
        return new TFCBiomeSource(seed, 8000, 0, 0, RockLayerSettings.getDefault(), ClimateSettings.DEFAULT, ClimateSettings.DEFAULT, biomeRegistry);
    }

    public TFCBiomeSource(long seed, int spawnDistance, int spawnCenterX, int spawnCenterZ, RockLayerSettings rockLayerSettings, ClimateSettings temperatureSettings, ClimateSettings rainfallSettings, Registry<Biome> biomeRegistry) {
        super(TFCBiomes.getAllKeys().stream().map(arg_0 -> biomeRegistry.m_206081_(arg_0)).collect(Collectors.toList()));
        this.seed = seed;
        this.spawnDistance = spawnDistance;
        this.spawnCenterX = spawnCenterX;
        this.spawnCenterZ = spawnCenterZ;
        this.rockLayerSettings = rockLayerSettings;
        this.temperatureSettings = temperatureSettings;
        this.rainfallSettings = rainfallSettings;
        this.biomeRegistry = biomeRegistry;
        this.chunkDataProvider = new ChunkDataProvider(new TFCChunkDataGenerator(seed, rockLayerSettings, temperatureSettings, rainfallSettings), rockLayerSettings);
        this.watersheds = new Watershed.Context(TFCLayers.createEarlyPlateLayers(seed), seed, 0.5f, 0.8f, 14, 0.2f);
        this.biomeLayer = new ConcurrentArea<BiomeExtension>(TFCLayers.createOverworldBiomeLayerWithRivers(seed, this.watersheds, IArtist.nope(), IArtist.nope()), TFCLayers::getFromLayerId);
    }

    @Override
    public Flow getRiverFlow(int quartX, int quartZ) {
        float scale = 0.0078125f;
        float x0 = (float)quartX * 0.0078125f;
        float z0 = (float)quartZ * 0.0078125f;
        for (MidpointFractal fractal : this.watersheds.getFractalsByPartition(quartX, quartZ)) {
            Flow flow;
            if (!fractal.maybeIntersect(x0, z0, 0.013f) || (flow = fractal.intersectWithFlow(x0, z0, 0.013f)) == Flow.NONE) continue;
            return flow;
        }
        return Flow.NONE;
    }

    @Override
    public ChunkDataProvider getChunkDataProvider() {
        return this.chunkDataProvider;
    }

    @Override
    public RockLayerSettings getRockLayerSettings() {
        return this.rockLayerSettings;
    }

    @Override
    public ClimateSettings getTemperatureSettings() {
        return this.temperatureSettings;
    }

    @Override
    public int getSpawnDistance() {
        return this.spawnDistance;
    }

    @Override
    public int getSpawnCenterX() {
        return this.spawnCenterX;
    }

    @Override
    public int getSpawnCenterZ() {
        return this.spawnCenterZ;
    }

    public Holder<Biome> m_203407_(int quartX, int quartY, int quartZ, @Nullable Climate.Sampler sampler) {
        return this.getNoiseBiome(quartX, quartZ);
    }

    @Override
    public Holder<Biome> getNoiseBiome(int quartX, int quartZ) {
        return this.biomeRegistry.m_206081_(this.getNoiseBiomeVariants(quartX, quartZ).key());
    }

    @Override
    public BiomeExtension getNoiseBiomeVariants(int quartX, int quartZ) {
        return this.biomeLayer.get(quartX, quartZ);
    }

    @Override
    public Holder<Biome> getBiome(BiomeExtension variants) {
        return this.biomeRegistry.m_206081_(variants.key());
    }

    public TFCBiomeSource withSeed(long seed) {
        return new TFCBiomeSource(seed, this.spawnDistance, this.spawnCenterX, this.spawnCenterZ, this.rockLayerSettings, this.temperatureSettings, this.rainfallSettings, this.biomeRegistry);
    }

    protected Codec<TFCBiomeSource> m_5820_() {
        return CODEC;
    }

    @Nullable
    public Pair<BlockPos, Holder<Biome>> m_207481_(int blockX, int blockY, int blockZ, int maxRadius, int step, Predicate<Holder<Biome>> biome, Random random, boolean findClosest, @Nullable Climate.Sampler sampler) {
        int radius;
        int minQuartX = QuartPos.m_175400_((int)blockX);
        int minQuartZ = QuartPos.m_175400_((int)blockZ);
        int maxQuartRadius = QuartPos.m_175400_((int)maxRadius);
        Pair pair = null;
        int count = 0;
        int n = radius = findClosest ? 0 : maxQuartRadius;
        while (radius <= maxQuartRadius) {
            for (int dz = -radius; dz <= radius; dz += step) {
                boolean atZEdge = Math.abs(dz) == radius;
                for (int dx = -radius; dx <= radius; dx += step) {
                    int z;
                    int x;
                    Holder<Biome> found;
                    if (findClosest) {
                        boolean atXEdge;
                        boolean bl = atXEdge = Math.abs(dx) == radius;
                        if (!atXEdge && !atZEdge) continue;
                    }
                    if (!biome.test(found = this.getNoiseBiome(x = minQuartX + dx, z = minQuartZ + dz))) continue;
                    if (pair == null || random.nextInt(count + 1) == 0) {
                        BlockPos pos = new BlockPos(QuartPos.m_175402_((int)x), blockY, QuartPos.m_175402_((int)z));
                        if (findClosest) {
                            return Pair.of((Object)pos, found);
                        }
                        pair = Pair.of((Object)pos, found);
                    }
                    ++count;
                }
            }
            radius += step;
        }
        return pair;
    }

    static {
        BIOME_SOURCE.register("overworld", () -> CODEC);
    }
}

