/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.chunkdata;

import com.google.common.collect.MapMaker;
import java.util.Map;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataCapability;
import net.dries007.tfc.world.chunkdata.ChunkDataGenerator;
import net.dries007.tfc.world.chunkdata.ChunkGeneratorExtension;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import org.jetbrains.annotations.Nullable;

public final class ChunkDataProvider {
    private final ChunkDataGenerator generator;
    private final RockLayerSettings rockLayerSettings;
    private final Map<ProtoChunk, ChunkData> partialChunkData;
    private final Map<ChunkPos, ProtoChunk> partialChunkLookup;

    public static ChunkDataProvider get(WorldGenLevel level) {
        return ChunkDataProvider.get(((ServerChunkCache)level.m_7726_()).m_8481_());
    }

    public static ChunkDataProvider get(ChunkGenerator chunkGenerator) {
        if (chunkGenerator instanceof ChunkGeneratorExtension) {
            ChunkGeneratorExtension extension = (ChunkGeneratorExtension)chunkGenerator;
            return extension.getChunkDataProvider();
        }
        throw new IllegalStateException("Tried to access ChunkDataProvider but none was present on " + chunkGenerator);
    }

    public ChunkDataProvider(ChunkDataGenerator generator, RockLayerSettings rockLayerSettings) {
        this.generator = generator;
        this.rockLayerSettings = rockLayerSettings;
        this.partialChunkData = new MapMaker().weakKeys().concurrencyLevel(4).makeMap();
        this.partialChunkLookup = new MapMaker().weakValues().concurrencyLevel(4).makeMap();
    }

    public ChunkData get(WorldGenLevel level, BlockPos pos) {
        return this.get(level.m_46865_(pos));
    }

    public ChunkData get(WorldGenLevel level, ChunkPos pos) {
        return this.get(level.m_6325_(pos.f_45578_, pos.f_45579_));
    }

    public ChunkData get(ChunkAccess chunk) {
        if (chunk instanceof ImposterProtoChunk) {
            ImposterProtoChunk imposter = (ImposterProtoChunk)chunk;
            return (ChunkData)imposter.m_62768_().getCapability(ChunkDataCapability.CAPABILITY).orElse((Object)ChunkData.EMPTY);
        }
        if (chunk instanceof ProtoChunk) {
            ProtoChunk proto = (ProtoChunk)chunk;
            ChunkData data = this.partialChunkData.computeIfAbsent(proto, c -> {
                ChunkData d = new ChunkData(c.m_7697_(), this.rockLayerSettings);
                this.partialChunkLookup.put(c.m_7697_(), (ProtoChunk)c);
                return d;
            });
            if (data.getStatus() == ChunkData.Status.EMPTY) {
                this.generator.generate(data);
                data.setStatus(ChunkData.Status.FULL);
            }
            return data;
        }
        if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            return (ChunkData)levelChunk.getCapability(ChunkDataCapability.CAPABILITY).orElse((Object)ChunkData.EMPTY);
        }
        throw new IllegalStateException("Cannot get chunk data from an unknown chunk: " + chunk.getClass() + " at " + chunk.m_7697_());
    }

    public ChunkData get(ChunkPos pos) {
        ChunkAccess chunk = (ChunkAccess)this.partialChunkLookup.get(pos);
        if (chunk != null) {
            return this.get(chunk);
        }
        return ChunkData.EMPTY;
    }

    public void loadPartial(ProtoChunk chunk, CompoundTag nbt) {
        this.partialChunkData.computeIfAbsent(chunk, c -> {
            ChunkData d = new ChunkData(c.m_7697_(), this.rockLayerSettings);
            this.partialChunkLookup.put(c.m_7697_(), (ProtoChunk)c);
            return d;
        }).deserializeNBT(nbt);
    }

    @Nullable
    public CompoundTag savePartial(ProtoChunk chunk) {
        ChunkData data = this.partialChunkData.get(chunk);
        return data == null ? null : data.serializeNBT();
    }

    public ChunkData promotePartialOrCreate(ChunkPos pos) {
        ProtoChunk partial = this.partialChunkLookup.remove(pos);
        ChunkData partialData = this.partialChunkData.remove(partial);
        if (partialData != null) {
            return partialData;
        }
        return new ChunkData(pos, this.rockLayerSettings);
    }

    public String toString() {
        return "ChunkDataProvider[" + this.generator.getClass().getSimpleName() + "]";
    }
}

