/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.chunkdata;

import java.util.List;
import java.util.Random;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.IArtist;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataGenerator;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.chunkdata.LerpFloatLayer;
import net.dries007.tfc.world.chunkdata.PlateTectonicsClassification;
import net.dries007.tfc.world.chunkdata.RockData;
import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.layer.framework.ConcurrentArea;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.settings.ClimateSettings;
import net.dries007.tfc.world.settings.RockLayer;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;

public class TFCChunkDataGenerator
implements ChunkDataGenerator {
    private final ConcurrentArea<RockSettings> bottomRockLayer;
    private final ConcurrentArea<RockSettings> middleRockLayer;
    private final ConcurrentArea<RockSettings> topRockLayer;
    private final ConcurrentArea<ForestType> forestTypeLayer;
    private final Noise2D temperatureNoise;
    private final Noise2D rainfallNoise;
    private final Noise2D layerHeightNoise;
    private final Noise2D forestWeirdnessNoise;
    private final Noise2D forestDensityNoise;
    private final ConcurrentArea<PlateTectonicsClassification> plateTectonicsInfo;

    public static ConcurrentArea<RockSettings> createRockLayer(Random seedGenerator, RockLayerSettings settings, List<RockSettings> rocks) {
        return new ConcurrentArea<RockSettings>(TFCLayers.createOverworldRockLayer(seedGenerator.nextLong(), settings.getScale(), rocks.size()), rocks::get);
    }

    public TFCChunkDataGenerator(long worldSeed, RockLayerSettings rockLayerSettings, ClimateSettings temperatureSettings, ClimateSettings rainfallSettings) {
        Random random = new Random(worldSeed);
        random.setSeed(worldSeed ^ random.nextLong());
        this.bottomRockLayer = TFCChunkDataGenerator.createRockLayer(random, rockLayerSettings, rockLayerSettings.getRocksForLayer(RockLayer.BOTTOM));
        this.middleRockLayer = TFCChunkDataGenerator.createRockLayer(random, rockLayerSettings, rockLayerSettings.getRocksForLayer(RockLayer.MIDDLE));
        this.topRockLayer = TFCChunkDataGenerator.createRockLayer(random, rockLayerSettings, rockLayerSettings.getRocksForLayer(RockLayer.TOP));
        this.layerHeightNoise = new OpenSimplex2D(random.nextInt()).octaves(2).scaled(-10.0f, 10.0f).spread(0.03f);
        this.temperatureNoise = ((Noise2D)(x, z) -> Helpers.triangle(1.0f, 0.0f, 1.0f / (4.0f * (float)temperatureSettings.scale()), temperatureSettings.endlessPoles() ? Mth.m_14036_((float)z, (float)(-temperatureSettings.scale()), (float)temperatureSettings.scale()) : z)).scaled(-20.0f, 30.0f).add(new OpenSimplex2D(random.nextInt()).octaves(2).spread(12.0f / (float)temperatureSettings.scale()).scaled(-2.0f, 2.0f));
        this.rainfallNoise = ((Noise2D)(x, z) -> Helpers.triangle(1.0f, 0.0f, 1.0f / (4.0f * (float)rainfallSettings.scale()), x)).scaled(0.0f, 500.0f).add(new OpenSimplex2D(random.nextInt()).octaves(2).spread(12.0f / (float)rainfallSettings.scale()).scaled(-50.0f, 50.0f)).clamped(0.0f, 500.0f);
        this.forestTypeLayer = new ConcurrentArea<ForestType>(TFCLayers.createOverworldForestLayer(random.nextLong(), IArtist.nope()), ForestType::valueOf);
        this.forestWeirdnessNoise = new OpenSimplex2D(random.nextInt()).octaves(4).spread(0.0025f).map(x -> 1.1f * Math.abs(x)).clamped(0.0f, 1.0f);
        this.forestDensityNoise = new OpenSimplex2D(random.nextInt()).octaves(4).spread(0.0025f).scaled(-0.2f, 1.2f).clamped(0.0f, 1.0f);
        this.plateTectonicsInfo = new ConcurrentArea<PlateTectonicsClassification>(TFCLayers.createOverworldPlateTectonicInfoLayer(worldSeed), PlateTectonicsClassification::valueOf);
    }

    @Override
    public void generate(ChunkData data) {
        ChunkPos pos = data.getPos();
        int chunkX = pos.m_45604_();
        int chunkZ = pos.m_45605_();
        float rainNW = this.rainfallNoise.noise(chunkX, chunkZ);
        float rainNE = this.rainfallNoise.noise(chunkX + 16, chunkZ);
        float rainSW = this.rainfallNoise.noise(chunkX, chunkZ + 16);
        float rainSE = this.rainfallNoise.noise(chunkX + 16, chunkZ + 16);
        float tempNW = this.temperatureNoise.noise(chunkX, chunkZ);
        float tempNE = this.temperatureNoise.noise(chunkX + 16, chunkZ);
        float tempSW = this.temperatureNoise.noise(chunkX, chunkZ + 16);
        float tempSE = this.temperatureNoise.noise(chunkX + 16, chunkZ + 16);
        ForestType forestType = this.forestTypeLayer.get(chunkX >> 4, chunkZ >> 4);
        float forestWeirdness = this.forestWeirdnessNoise.noise(chunkX + 8, chunkZ + 8);
        float forestDensity = this.forestDensityNoise.noise(chunkX + 8, chunkZ + 8);
        RockSettings[] bottomLayer = new RockSettings[256];
        RockSettings[] middleLayer = new RockSettings[256];
        RockSettings[] topLayer = new RockSettings[256];
        int[] rockLayerHeight = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                bottomLayer[x + 16 * z] = this.bottomRockLayer.get(chunkX + x, chunkZ + z);
                middleLayer[x + 16 * z] = this.middleRockLayer.get(chunkX + x, chunkZ + z);
                topLayer[x + 16 * z] = this.topRockLayer.get(chunkX + x, chunkZ + z);
                rockLayerHeight[x + 16 * z] = (int)this.layerHeightNoise.noise(chunkX + x, chunkZ + z);
            }
        }
        data.setRainfall(new LerpFloatLayer(rainNW, rainNE, rainSW, rainSE));
        data.setAverageTemp(new LerpFloatLayer(tempNW, tempNE, tempSW, tempSE));
        data.setFloraData(forestType, forestWeirdness, forestDensity);
        data.setPlateTectonicsInfo(this.plateTectonicsInfo.get(data.getPos().f_45578_, data.getPos().f_45579_));
        data.setRockData(new RockData(bottomLayer, middleLayer, topLayer, rockLayerHeight));
    }
}

