/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.dries007.tfc.util.collections.IWeighted;
import net.dries007.tfc.world.Codecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.jetbrains.annotations.Nullable;

public record FissureConfig(Optional<BlockState> wallState, BlockState fluidState, int count, int radius, VerticalAnchor minDepth, int minPieces, int maxPieces, int maxPieceLength, Optional<Decoration> decoration) implements FeatureConfiguration
{
    public static final Codec<FissureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.BLOCK_STATE.optionalFieldOf("wall_state").forGetter(c -> c.wallState), (App)Codecs.BLOCK_STATE.fieldOf("fluid_state").forGetter(c -> c.fluidState), (App)Codecs.POSITIVE_INT.optionalFieldOf("count", (Object)5).forGetter(c -> c.count), (App)Codecs.POSITIVE_INT.optionalFieldOf("radius", (Object)12).forGetter(c -> c.radius), (App)VerticalAnchor.f_158914_.optionalFieldOf("min_depth", (Object)VerticalAnchor.m_158930_((int)16)).forGetter(c -> c.minDepth), (App)Codecs.POSITIVE_INT.optionalFieldOf("min_pieces", (Object)10).forGetter(c -> c.minPieces), (App)Codecs.POSITIVE_INT.optionalFieldOf("max_pieces", (Object)24).forGetter(c -> c.maxPieces), (App)Codecs.POSITIVE_INT.optionalFieldOf("max_piece_length", (Object)6).forGetter(c -> c.maxPieceLength), (App)Decoration.CODEC.optionalFieldOf("decoration").forGetter(c -> c.decoration)).apply((Applicative)instance, FissureConfig::new));

    public record Decoration(Map<Block, IWeighted<BlockState>> states, int rarity, int radius, int count) {
        public static final Codec<Decoration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.BLOCK_TO_WEIGHTED_BLOCKSTATE.fieldOf("blocks").forGetter(c -> c.states), (App)Codecs.POSITIVE_INT.fieldOf("rarity").forGetter(c -> c.rarity), (App)Codecs.POSITIVE_INT.fieldOf("radius").forGetter(c -> c.radius), (App)Codecs.POSITIVE_INT.fieldOf("count").forGetter(c -> c.count)).apply((Applicative)instance, Decoration::new));

        @Nullable
        public BlockState getState(BlockState stoneState, Random random) {
            IWeighted<BlockState> weighted = this.states.get(stoneState.m_60734_());
            if (weighted != null) {
                return weighted.get(random);
            }
            return null;
        }
    }
}

