/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.feature.FissureConfig;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.jetbrains.annotations.Nullable;

public class FissureFeature
extends Feature<FissureConfig> {
    public static void placeFissure(WorldGenLevel level, BlockPos startPos, BlockPos centerPos, BlockPos.MutableBlockPos mutablePos, Random random, BlockState insideState, BlockState wallState, int minPieces, int maxPieces, int maxPieceLength, int minDepth, int radius, @Nullable FissureConfig.Decoration decoration) {
        int pieces = minPieces + random.nextInt(maxPieces - minPieces);
        BlockPos topPos = startPos.m_7949_();
        for (int i = 0; i < pieces; ++i) {
            int pieceDepth = 1 + random.nextInt(maxPieceLength);
            for (int dy = 1; dy <= pieceDepth; ++dy) {
                level.m_7731_((BlockPos)mutablePos.m_122154_((Vec3i)topPos, 0, -dy, 0), insideState, 2);
                level.m_7731_((BlockPos)mutablePos.m_122154_((Vec3i)topPos, -1, -dy, 0), wallState, 2);
                level.m_7731_((BlockPos)mutablePos.m_122154_((Vec3i)topPos, 1, -dy, 0), wallState, 2);
                level.m_7731_((BlockPos)mutablePos.m_122154_((Vec3i)topPos, 0, -dy, -1), wallState, 2);
                level.m_7731_((BlockPos)mutablePos.m_122154_((Vec3i)topPos, 0, -dy, 1), wallState, 2);
                if (decoration == null) continue;
                for (int j = 0; j < decoration.count(); ++j) {
                    if (random.nextInt(decoration.rarity()) != 0) continue;
                    mutablePos.m_122154_((Vec3i)topPos, random.nextInt(decoration.radius()) - random.nextInt(decoration.radius()), random.nextInt(3) - random.nextInt(3) - dy, random.nextInt(decoration.radius()) - random.nextInt(decoration.radius()));
                    BlockState stoneState = level.m_8055_((BlockPos)mutablePos);
                    BlockState decorationState = decoration.getState(stoneState, random);
                    if (decorationState == null) continue;
                    level.m_7731_((BlockPos)mutablePos, decorationState, 2);
                }
            }
            Direction branchDirection = FissureFeature.randomBoundedDirection(random, centerPos, topPos, radius);
            topPos = mutablePos.m_122154_((Vec3i)topPos, 0, -pieceDepth, 0).m_122173_(branchDirection).m_7949_();
            level.m_7731_((BlockPos)mutablePos.m_122190_((Vec3i)topPos), insideState, 2);
            level.m_7731_((BlockPos)mutablePos.m_122154_((Vec3i)topPos, 0, 1, 0), wallState, 2);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (direction == branchDirection.m_122424_()) continue;
                level.m_7731_((BlockPos)mutablePos.m_122159_((Vec3i)topPos, direction), wallState, 2);
            }
            if (topPos.m_123342_() < minDepth) break;
        }
    }

    private static Direction randomBoundedDirection(Random random, BlockPos center, BlockPos target, int radius) {
        Direction direction = Direction.Plane.HORIZONTAL.m_122560_(random);
        int distX = target.m_123341_() - center.m_123341_();
        int distZ = target.m_123343_() - center.m_123343_();
        switch (direction) {
            case EAST: {
                if (distX > radius) {
                    return Direction.WEST;
                }
                return direction;
            }
            case WEST: {
                if (distX < -radius) {
                    return Direction.EAST;
                }
                return direction;
            }
            case NORTH: {
                if (distZ < -radius) {
                    return Direction.SOUTH;
                }
                return direction;
            }
            case SOUTH: {
                if (distZ > radius) {
                    return Direction.NORTH;
                }
                return direction;
            }
        }
        return direction;
    }

    public FissureFeature(Codec<FissureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FissureConfig> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random rand = context.m_159776_();
        FissureConfig config = (FissureConfig)context.m_159778_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int placeCount = 1 + rand.nextInt(config.count());
        int minDepth = config.minDepth().m_142322_(new WorldGenerationContext(context.m_159775_(), (LevelHeightAccessor)level));
        BlockState insideState = config.wallState().orElseGet(() -> {
            ChunkDataProvider provider = ChunkDataProvider.get(context.m_159775_());
            ChunkData data = provider.get(context.m_159774_(), pos);
            RockSettings rock = data.getRockData().getRock(pos.m_123341_(), context.m_159775_().m_142062_() + 1, pos.m_123343_());
            return rock.raw().m_49966_();
        });
        for (int i = 0; i < placeCount; ++i) {
            mutablePos.m_122154_((Vec3i)pos, rand.nextInt(config.radius()) - rand.nextInt(config.radius()), 0, rand.nextInt(config.radius()) - rand.nextInt(config.radius()));
            mutablePos.m_142448_(level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, mutablePos.m_123341_(), mutablePos.m_123343_()));
            FissureFeature.placeFissure(level, pos, mutablePos.m_7949_(), mutablePos, rand, config.fluidState(), insideState, config.minPieces(), config.maxPieces(), config.maxPieceLength(), minDepth, config.radius(), config.decoration().orElse(null));
        }
        return true;
    }
}

