/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.plant;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.plant.ColumnPlantConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;

public class TFCKelpFeature
extends Feature<ColumnPlantConfig> {
    public TFCKelpFeature(Codec<ColumnPlantConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<ColumnPlantConfig> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random rand = context.m_159776_();
        ColumnPlantConfig config = (ColumnPlantConfig)context.m_159778_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int radius = config.radius();
        boolean placedAny = false;
        for (int i = 0; i < config.tries(); ++i) {
            mutablePos.m_122154_((Vec3i)pos, rand.nextInt(radius) - rand.nextInt(radius), 0, rand.nextInt(radius) - rand.nextInt(radius));
            mutablePos.m_122190_((Vec3i)level.m_5452_(Heightmap.Types.OCEAN_FLOOR, (BlockPos)mutablePos));
            BlockState state = level.m_8055_((BlockPos)mutablePos);
            Fluid fluid = state.m_60819_().m_76152_();
            BlockState bodyState = FluidHelpers.fillWithFluid(config.bodyState(), fluid);
            BlockState headState = FluidHelpers.fillWithFluid(config.headState(), fluid);
            if (bodyState == null || headState == null || !bodyState.m_60710_((LevelReader)level, (BlockPos)mutablePos) || !FluidHelpers.isAirOrEmptyFluid(state)) continue;
            this.placeColumn((LevelAccessor)level, rand, mutablePos, Mth.m_14072_((Random)rand, (int)config.minHeight(), (int)config.maxHeight()), 17, 25, bodyState, headState);
            placedAny = true;
        }
        return placedAny;
    }

    private void placeColumn(LevelAccessor level, Random rand, BlockPos.MutableBlockPos mutablePos, int height, int minAge, int maxAge, BlockState body, BlockState head) {
        for (int i = 1; i <= height; ++i) {
            if (level.m_46801_((BlockPos)mutablePos) && body.m_60710_((LevelReader)level, (BlockPos)mutablePos)) {
                if (i == height || !level.m_46801_(mutablePos.m_7494_())) {
                    if (!Helpers.isBlock(level.m_8055_(mutablePos.m_7495_()), head.m_60734_())) {
                        level.m_7731_((BlockPos)mutablePos, (BlockState)head.m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(Mth.m_14072_((Random)rand, (int)minAge, (int)maxAge))), 16);
                    }
                    return;
                }
                level.m_7731_((BlockPos)mutablePos, body, 16);
            }
            mutablePos.m_122173_(Direction.UP);
        }
    }
}

