/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.plant;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.plant.ColumnPlantConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class TFCTwistingVinesFeature
extends Feature<ColumnPlantConfig> {
    public static void placeColumn(LevelAccessor level, Random rand, BlockPos.MutableBlockPos mutablePos, int height, int minAge, int maxAge, BlockState body, BlockState head) {
        for (int i = 1; i <= height; ++i) {
            if (EnvironmentHelpers.isWorldgenReplaceable((WorldGenLevel)level, (BlockPos)mutablePos)) {
                mutablePos.m_122184_(0, 1, 0);
                if (i == height || !level.m_46859_((BlockPos)mutablePos)) {
                    mutablePos.m_122184_(0, -1, 0);
                    level.m_7731_((BlockPos)mutablePos, (BlockState)head.m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(Mth.m_14072_((Random)rand, (int)minAge, (int)maxAge))), 2);
                    break;
                }
                mutablePos.m_122184_(0, -1, 0);
                level.m_7731_((BlockPos)mutablePos, body, 2);
            }
            mutablePos.m_122184_(0, 1, 0);
        }
    }

    public TFCTwistingVinesFeature(Codec<ColumnPlantConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<ColumnPlantConfig> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random rand = context.m_159776_();
        ColumnPlantConfig config = (ColumnPlantConfig)context.m_159778_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        boolean placedAny = false;
        int radius = config.radius();
        for (int i = 0; i < config.tries(); ++i) {
            mutablePos.m_122154_((Vec3i)pos, Helpers.triangle(rand, radius), 0, Helpers.triangle(rand, radius));
            mutablePos.m_122184_(0, -1, 0);
            if (!Helpers.isBlock(level.m_8055_((BlockPos)mutablePos), TFCTags.Blocks.GRASS_PLANTABLE_ON)) {
                return false;
            }
            mutablePos.m_122184_(0, 1, 0);
            if (!EnvironmentHelpers.isWorldgenReplaceable(level, (BlockPos)mutablePos)) continue;
            TFCTwistingVinesFeature.placeColumn((LevelAccessor)level, rand, mutablePos, rand.nextInt(config.maxHeight() - config.minHeight()) + config.minHeight(), 17, 25, config.bodyState(), config.headState());
            placedAny = true;
        }
        return placedAny;
    }
}

