/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.dries007.tfc.world.feature.tree.OverlayTreeConfig;
import net.dries007.tfc.world.feature.tree.TreeFeature;
import net.dries007.tfc.world.feature.tree.TreeHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class OverlayTreeFeature
extends TreeFeature<OverlayTreeConfig> {
    public OverlayTreeFeature(Codec<OverlayTreeConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<OverlayTreeConfig> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random random = context.m_159776_();
        OverlayTreeConfig config = (OverlayTreeConfig)context.m_159778_();
        ChunkPos chunkPos = new ChunkPos(pos);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        StructureManager manager = TreeHelpers.getStructureManager(level);
        StructurePlaceSettings settings = TreeHelpers.getPlacementSettings((LevelHeightAccessor)level, chunkPos, random);
        StructureTemplate structureBase = manager.m_74341_(config.base());
        StructureTemplate structureOverlay = manager.m_74341_(config.overlay());
        if (TreeHelpers.isValidLocation((LevelAccessor)level, pos, settings, config.placement())) {
            config.trunk().ifPresent(trunk -> {
                int height = TreeHelpers.placeTrunk(level, (BlockPos)mutablePos, random, settings, trunk);
                mutablePos.m_122184_(0, height, 0);
            });
            TreeHelpers.placeTemplate(structureBase, settings, (LevelAccessor)level, mutablePos.m_141950_((Vec3i)TreeHelpers.transformCenter(structureBase.m_163801_(), settings)));
            settings.m_74383_((StructureProcessor)new BlockRotProcessor(config.overlayIntegrity()));
            TreeHelpers.placeTemplate(structureOverlay, settings, (LevelAccessor)level, mutablePos.m_141950_((Vec3i)TreeHelpers.transformCenter(structureOverlay.m_163801_(), settings)));
            return true;
        }
        return false;
    }
}

