/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.world.level.block.state.BlockState;

public record TrunkConfig(BlockState state, int minHeight, int maxHeight, int width) {
    public static final Codec<TrunkConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("state").forGetter(c -> c.state), (App)Codec.INT.fieldOf("min_height").forGetter(c -> c.minHeight), (App)Codec.INT.fieldOf("max_height").forGetter(c -> c.maxHeight), (App)Codec.INT.fieldOf("width").forGetter(c -> c.width)).apply((Applicative)instance, TrunkConfig::new)).comapFlatMap(c -> {
        if (c.minHeight >= c.maxHeight) {
            return DataResult.error((String)("Min height (provided = " + c.minHeight + ") must not be greater or equal to max height (provided = " + c.maxHeight + ")"));
        }
        return DataResult.success((Object)c);
    }, Function.identity());

    public int getHeight(Random random) {
        if (this.maxHeight == this.minHeight) {
            return this.minHeight;
        }
        return this.minHeight + random.nextInt(1 + this.maxHeight - this.minHeight);
    }
}

