/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.vein;

import com.mojang.serialization.Codec;
import net.dries007.tfc.world.feature.vein.DiscVeinConfig;
import net.dries007.tfc.world.feature.vein.Vein;
import net.dries007.tfc.world.feature.vein.VeinFeature;
import net.dries007.tfc.world.noise.Metaballs2D;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class DiscVeinFeature
extends VeinFeature<DiscVeinConfig, DiscVein> {
    public DiscVeinFeature(Codec<DiscVeinConfig> codec) {
        super(codec);
    }

    @Override
    protected float getChanceToGenerate(int x, int y, int z, DiscVein vein, DiscVeinConfig config) {
        if (Math.abs(y) <= config.getHeight() && vein.metaballs.inside(x, z)) {
            return config.getDensity();
        }
        return 0.0f;
    }

    @Override
    protected DiscVein createVein(WorldGenerationContext context, int chunkX, int chunkZ, RandomSource random, DiscVeinConfig config) {
        return new DiscVein(this.defaultPos(context, chunkX, chunkZ, random, config), random, config.getSize());
    }

    @Override
    protected BoundingBox getBoundingBox(DiscVeinConfig config, DiscVein vein) {
        return new BoundingBox(-config.getSize(), -config.getHeight(), -config.getSize(), config.getSize(), config.getHeight(), config.getSize());
    }

    static class DiscVein
    extends Vein {
        final Metaballs2D metaballs;
        final int width;

        DiscVein(BlockPos pos, RandomSource random, int size) {
            super(pos);
            this.metaballs = Metaballs2D.simple(random, size);
            this.width = size;
        }
    }
}

