/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer;

import net.dries007.tfc.world.layer.framework.AreaContext;
import net.dries007.tfc.world.layer.framework.TypedArea;
import net.dries007.tfc.world.layer.framework.TypedTransformLayer;

public abstract class TypedZoomLayer<A>
implements TypedTransformLayer<A> {
    @Override
    public A apply(AreaContext context, TypedArea<A> area, int x, int z) {
        int parentX = x >> 1;
        int parentZ = z >> 1;
        int offsetX = x & 1;
        int offsetZ = z & 1;
        A northWest = area.get(parentX, parentZ);
        context.setSeed(parentX, parentZ);
        if (offsetX == 0 && offsetZ == 0) {
            return northWest;
        }
        if (offsetX == 0) {
            return context.choose(northWest, area.get(parentX, parentZ + 1));
        }
        if (offsetZ == 0) {
            return context.choose(northWest, area.get(parentX + 1, parentZ));
        }
        return this.choose(context, northWest, area.get(parentX, parentZ + 1), area.get(parentX + 1, parentZ), area.get(parentX + 1, parentZ + 1));
    }

    public abstract A choose(AreaContext var1, A var2, A var3, A var4, A var5);

    public static class Fuzzy<A>
    extends TypedZoomLayer<A> {
        @Override
        public A choose(AreaContext context, A first, A second, A third, A fourth) {
            return context.choose(first, second, third, fourth);
        }
    }

    public static class Normal<A>
    extends TypedZoomLayer<A> {
        @Override
        public A choose(AreaContext context, A first, A second, A third, A fourth) {
            if (first == second) {
                return first == third || third != fourth ? first : context.choose(first, third);
            }
            if (first == third) {
                return second != fourth ? first : context.choose(first, second);
            }
            if (first == fourth) {
                return second != third ? first : context.choose(first, second);
            }
            if (second == third || second == fourth) {
                return second;
            }
            if (third == fourth) {
                return third;
            }
            return context.choose(first, second, third, fourth);
        }
    }
}

