/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.stream.Stream;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.placement.TFCPlacements;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ClimatePlacement
extends PlacementModifier {
    public static final Codec<ClimatePlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("min_temperature", (Object)Float.valueOf(-3.4028235E38f)).forGetter(c -> Float.valueOf(c.minTemp)), (App)Codec.FLOAT.optionalFieldOf("max_temperature", (Object)Float.valueOf(Float.MAX_VALUE)).forGetter(c -> Float.valueOf(c.maxTemp)), (App)Codec.FLOAT.optionalFieldOf("min_rainfall", (Object)Float.valueOf(-3.4028235E38f)).forGetter(c -> Float.valueOf(c.minRainfall)), (App)Codec.FLOAT.optionalFieldOf("max_rainfall", (Object)Float.valueOf(Float.MAX_VALUE)).forGetter(c -> Float.valueOf(c.maxRainfall)), (App)ForestType.CODEC.optionalFieldOf("min_forest", (Object)ForestType.NONE).forGetter(c -> c.minForest), (App)ForestType.CODEC.optionalFieldOf("max_forest", (Object)ForestType.OLD_GROWTH).forGetter(c -> c.maxForest), (App)Codec.BOOL.optionalFieldOf("fuzzy", (Object)false).forGetter(c -> c.fuzzy)).apply((Applicative)instance, ClimatePlacement::new));
    private final float minTemp;
    private final float maxTemp;
    private final float targetTemp;
    private final float minRainfall;
    private final float maxRainfall;
    private final float targetRainfall;
    private final ForestType minForest;
    private final ForestType maxForest;
    private final boolean fuzzy;

    public ClimatePlacement(float minTemp, float maxTemp, float minRainfall, float maxRainfall, ForestType minForest, ForestType maxForest, boolean fuzzy) {
        this.minTemp = minTemp;
        this.maxTemp = maxTemp;
        this.targetTemp = (minTemp + maxTemp) / 2.0f;
        this.minRainfall = minRainfall;
        this.maxRainfall = maxRainfall;
        this.targetRainfall = (minRainfall + maxRainfall) / 2.0f;
        this.minForest = minForest;
        this.maxForest = maxForest;
        this.fuzzy = fuzzy;
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)TFCPlacements.CLIMATE.get();
    }

    public boolean isValid(ChunkData data, BlockPos pos, Random random) {
        float temperature = data.getAverageTemp(pos);
        float rainfall = data.getRainfall(pos);
        ForestType forestType = data.getForestType();
        if (this.minTemp <= temperature && temperature <= this.maxTemp && this.minRainfall <= rainfall && rainfall <= this.maxRainfall && this.minForest.ordinal() <= forestType.ordinal() && forestType.ordinal() <= this.maxForest.ordinal()) {
            if (this.fuzzy) {
                float normTempDelta = Math.abs(temperature - this.targetTemp) / (this.maxTemp - this.minTemp);
                float normRainfallDelta = Math.abs(rainfall - this.targetRainfall) / (this.maxRainfall - this.minRainfall);
                return random.nextFloat() * random.nextFloat() > Math.max(normTempDelta, normRainfallDelta);
            }
            return true;
        }
        return false;
    }

    public Stream<BlockPos> m_183381_(PlacementContext context, Random random, BlockPos pos) {
        ChunkDataProvider provider = ChunkDataProvider.get(context.m_191831_());
        ChunkData data = provider.get(context.m_191831_(), pos);
        if (this.isValid(data, pos, random)) {
            return Stream.of(pos);
        }
        return Stream.empty();
    }
}

