/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.stream.Stream;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.placement.TFCPlacements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.material.Fluid;

public class NearWaterPlacement
extends PlacementModifier {
    public static final Codec<NearWaterPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.NONNEGATIVE_INT.optionalFieldOf("radius", (Object)2).forGetter(c -> c.radius)).apply((Applicative)instance, NearWaterPlacement::new));
    private final int radius;

    public NearWaterPlacement(int radius) {
        this.radius = radius;
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)TFCPlacements.NEAR_WATER.get();
    }

    public Stream<BlockPos> m_183381_(PlacementContext context, Random random, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = -this.radius; x <= this.radius; ++x) {
            for (int z = -this.radius; z <= this.radius; ++z) {
                for (int y = 0; y >= -this.radius; --y) {
                    mutablePos.m_122190_((Vec3i)pos).m_122184_(x, y, z);
                    BlockState state = context.m_191828_((BlockPos)mutablePos);
                    if (!Helpers.isFluid(state.m_60819_(), (TagKey<Fluid>)FluidTags.f_13131_)) continue;
                    return Stream.of(pos);
                }
            }
        }
        return Stream.empty();
    }
}

