/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.river;

import com.google.common.base.Preconditions;
import net.dries007.tfc.world.river.Flow;
import net.dries007.tfc.world.river.RiverHelpers;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.RandomSource;

public class MidpointFractal {
    private static final float JITTER_MIN = 0.2f;
    private static final float JITTER_RANGE = 0.4f;
    private static final int MAX_BISECTIONS = 10;
    private static final float[] ENCOMPASSING_RANGES = new float[10];
    public final float[] segments;
    private final float norm;

    private static float[] bisect(RandomSource random, int bisections, float[] segments) {
        for (int i = 0; i < bisections; ++i) {
            float[] splitSegments = new float[(segments.length << 1) - 2];
            splitSegments[0] = segments[0];
            splitSegments[1] = segments[1];
            int splitIndex = 2;
            for (int index = 0; index < segments.length - 2; index += 2) {
                float sourceX = segments[index];
                float sourceY = segments[index + 1];
                float drainX = segments[index + 2];
                float drainY = segments[index + 3];
                float norm = RiverHelpers.normInf(sourceX - drainX, sourceY - drainY);
                float bisectX = (random.nextFloat() * 0.4f - 0.2f) * norm + (sourceX + drainX) * 0.5f;
                float bisectY = (random.nextFloat() * 0.4f - 0.2f) * norm + (sourceY + drainY) * 0.5f;
                splitSegments[splitIndex] = bisectX;
                splitSegments[splitIndex + 1] = bisectY;
                splitSegments[splitIndex + 2] = drainX;
                splitSegments[splitIndex + 3] = drainY;
                splitIndex += 4;
            }
            segments = splitSegments;
        }
        return segments;
    }

    public MidpointFractal(RandomSource random, int bisections, float sourceX, float sourceY, float drainX, float drainY) {
        Preconditions.checkArgument((bisections >= 0 && bisections < 10 ? 1 : 0) != 0, (Object)"Bisections must be within [0, MAX_BISECTIONS)");
        this.segments = MidpointFractal.bisect(random, bisections, new float[]{sourceX, sourceY, drainX, drainY});
        this.norm = ENCOMPASSING_RANGES[bisections] * RiverHelpers.normInf(sourceX - drainX, sourceY - drainY);
    }

    public boolean maybeIntersect(float x, float y, float distance) {
        float t;
        float d = RiverHelpers.distancePointToLineSq(this.segments[0], this.segments[1], this.segments[this.segments.length - 2], this.segments[this.segments.length - 1], x, y);
        return d <= (t = distance + this.norm) * t;
    }

    public boolean intersect(float x, float y, float distance) {
        return this.intersectIndex(x, y, distance * distance) != -1;
    }

    public Flow intersectWithFlow(float x, float y, float distance) {
        int i = this.intersectIndex(x, y, distance * distance);
        if (i != -1) {
            float sourceX = this.segments[i];
            float sourceY = this.segments[i + 1];
            float drainX = this.segments[i + 2];
            float drainY = this.segments[i + 3];
            float angle = (float)Mth.m_14136_((double)(-(drainY - sourceY)), (double)(drainX - sourceX));
            return Flow.fromAngle(angle);
        }
        return Flow.NONE;
    }

    private int intersectIndex(float x, float y, float distSq) {
        for (int i = 0; i < this.segments.length - 2; i += 2) {
            float d = RiverHelpers.distancePointToLineSq(this.segments[i], this.segments[i + 1], this.segments[i + 2], this.segments[i + 3], x, y);
            if (!(d < distSq)) continue;
            return i;
        }
        return -1;
    }

    static {
        float sqrt2 = (float)Math.sqrt(2.0);
        float delta = 0.0f;
        float midpointDelta = 0.0f;
        float norm = 1.0f;
        for (int i = 0; i < 10; ++i) {
            MidpointFractal.ENCOMPASSING_RANGES[i] = Math.max(delta, midpointDelta);
            float prevMidpoint = midpointDelta;
            midpointDelta = 0.5f * (delta + midpointDelta) + sqrt2 * 0.2f * norm;
            delta = Math.max(prevMidpoint, delta);
            norm *= 0.7f;
        }
    }
}

