/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.settings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.Codecs;
import net.minecraft.resources.ResourceLocation;

public record ClimateSettings(int scale, boolean endlessPoles) {
    public static final Codec<ClimateSettings> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("scale").forGetter(c -> c.scale), (App)Codec.BOOL.fieldOf("endless_poles").forGetter(c -> c.endlessPoles)).apply((Applicative)instance, ClimateSettings::new));
    private static final Map<ResourceLocation, ClimateSettings> PRESETS = new ConcurrentHashMap<ResourceLocation, ClimateSettings>();
    public static final Codec<ClimateSettings> CODEC = Codec.either((Codec)ResourceLocation.f_135803_, DIRECT_CODEC).comapFlatMap(e -> (DataResult)e.map(id -> Codecs.requireNonNull(PRESETS.get(id), "No climate settings preset for id: " + id), DataResult::success), Either::right);
    public static final ClimateSettings DEFAULT = ClimateSettings.register("default", new ClimateSettings(20000, false));

    public static ClimateSettings register(ResourceLocation id, ClimateSettings preset) {
        PRESETS.put(id, preset);
        return preset;
    }

    private static ClimateSettings register(String id, ClimateSettings preset) {
        return ClimateSettings.register(Helpers.identifier(id), preset);
    }
}

