/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.climate.OverworldClimateModel;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class OceanSurfaceBuilder
implements SurfaceBuilder {
    public static final SurfaceBuilderFactory INSTANCE = OceanSurfaceBuilder::new;
    private final NormalNoise icebergPillarNoise;
    private final NormalNoise icebergPillarRoofNoise;
    private final NormalNoise icebergSurfaceNoise;

    public OceanSurfaceBuilder(long seed) {
        XoroshiroRandomSource generator = new XoroshiroRandomSource(seed);
        this.icebergPillarNoise = NormalNoise.m_192848_((RandomSource)generator.m_183458_(), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(-6, 1.0, new double[]{1.0, 1.0, 1.0}));
        this.icebergPillarRoofNoise = NormalNoise.m_192848_((RandomSource)generator.m_183458_(), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(-3, 1.0, new double[0]));
        this.icebergSurfaceNoise = NormalNoise.m_192848_((RandomSource)generator.m_183458_(), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(-6, 1.0, new double[]{1.0, 1.0}));
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY);
        this.frozenOceanExtension(context, startY, endY);
    }

    private void frozenOceanExtension(SurfaceBuilderContext context, int startY, int endY) {
        BlockState packedIce = Blocks.f_50354_.m_49966_();
        BlockState snow = Blocks.f_50127_.m_49966_();
        int seaLevel = context.getSeaLevel();
        int x = context.pos().m_123341_();
        int z = context.pos().m_123343_();
        RandomSource random = context.random();
        OverworldClimateModel model = OverworldClimateModel.getIfPresent(context.level());
        if (model == null) {
            return;
        }
        float maxAnnualTemperature = model.getAverageMonthlyTemperature(z, seaLevel, context.averageTemperature(), 1.0f);
        if (maxAnnualTemperature > 2.0f) {
            return;
        }
        float temperatureFactor = Mth.m_184631_((float)maxAnnualTemperature, (float)-4.0f, (float)2.0f, (float)0.0f, (float)6.0f);
        double baseNoise = Math.min(Math.abs(this.icebergSurfaceNoise.m_75380_((double)x, 0.0, (double)z) * 8.25), this.icebergPillarNoise.m_75380_((double)x * 1.28, 0.0, (double)z * 1.28) * 15.0);
        if (baseNoise > 1.8) {
            double icebergMinY;
            double pillarNoise = Math.abs(this.icebergPillarRoofNoise.m_75380_((double)x * 1.17, 0.0, (double)z * 1.17) * 1.5);
            double icebergMaxY = Math.min(baseNoise * baseNoise * 1.2, Math.ceil(pillarNoise * 40.0) + 14.0);
            if ((icebergMaxY -= (double)temperatureFactor) > 2.0) {
                icebergMinY = (double)seaLevel - icebergMaxY - 7.0;
                icebergMaxY += (double)seaLevel;
            } else {
                icebergMaxY = 0.0;
                icebergMinY = 0.0;
            }
            int snowDepth = 2 + random.nextInt(4);
            int snowBoundaryY = seaLevel + 18 + random.nextInt(10);
            int placedSnow = 0;
            for (int y = Math.max(startY, (int)icebergMaxY + 1); y >= endY; --y) {
                BlockState state = context.getBlockState(y);
                if (!(state.m_60795_() && (double)y < icebergMaxY && random.nextDouble() > 0.01) && (state.m_60734_() != TFCBlocks.SALT_WATER.get() && state.m_60734_() != Blocks.f_49990_ || y <= (int)icebergMinY || y >= seaLevel || icebergMinY == 0.0 || !(random.nextDouble() > 0.15))) continue;
                if (placedSnow <= snowDepth && y > snowBoundaryY) {
                    context.setBlockState(y, snow);
                    ++placedSnow;
                    continue;
                }
                context.setBlockState(y, packedIce);
            }
        }
    }
}

