/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.biome.VolcanoNoise;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class VolcanoesSurfaceBuilder
implements SurfaceBuilder {
    private final SurfaceBuilder parent;
    private final Noise2D heightNoise;
    private final VolcanoNoise volcanoNoise;

    public static SurfaceBuilderFactory create(SurfaceBuilderFactory parent) {
        return seed -> new VolcanoesSurfaceBuilder(parent.apply(seed), seed);
    }

    public VolcanoesSurfaceBuilder(SurfaceBuilder parent, long seed) {
        this.parent = parent;
        this.volcanoNoise = new VolcanoNoise(seed);
        this.heightNoise = new OpenSimplex2D(seed + 71829341L).octaves(2).spread(0.1f).scaled(-4.0f, 4.0f);
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        float easing;
        BiomeExtension variants = TFCBiomes.getExtensionOrThrow(context.level(), context.biome());
        if (variants.isVolcanic() && (easing = this.volcanoNoise.calculateEasing(context.pos().m_123341_(), context.pos().m_123343_(), variants.getVolcanoRarity())) > 0.6f && (float)startY > (float)variants.getVolcanoBasaltHeight() + this.heightNoise.noise(context.pos().m_123341_(), context.pos().m_123343_())) {
            this.buildVolcanicSurface(context, startY, endY, easing);
            return;
        }
        this.parent.buildSurface(context, startY, endY);
    }

    private void buildVolcanicSurface(SurfaceBuilderContext context, int startY, int endY, float easing) {
        BlockState basalt = ((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.BASALT).get((Object)Rock.BlockType.RAW).get()).m_49966_();
        int surfaceDepth = -1;
        for (int y = startY; y >= endY; --y) {
            BlockState stateAt = context.getBlockState(y);
            if (stateAt.m_60795_()) {
                surfaceDepth = -1;
                continue;
            }
            if (!context.isDefaultBlock(stateAt)) continue;
            if (surfaceDepth == -1) {
                surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(y, 13, 0.0, 4);
                surfaceDepth = Mth.m_14045_((int)((int)((float)surfaceDepth * (easing - 0.6f) / 0.4f)), (int)2, (int)11);
                context.setBlockState(y, basalt);
                continue;
            }
            if (surfaceDepth <= 0) continue;
            --surfaceDepth;
            context.setBlockState(y, basalt);
        }
    }
}

